@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity for the Provisioned cluster.
 * @property principalId The principal id of provisioned cluster identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant id associated with the provisioned cluster. This property will only be provided for a system assigned identity.
 * @property type The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
 */
public data class ProvisionedClusterIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.ProvisionedClusterIdentityResponse):
            ProvisionedClusterIdentityResponse = ProvisionedClusterIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
