@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * HybridAKSClusterStatus defines the observed state of HybridAKSCluster
 * @property addonStatus AddonStatus - Status of Addons
 * @property errorMessage ErrorMessage - Error messages during creation of cluster
 * @property featuresStatus Additional features status like Arc Agent Onboarding.
 * @property provisioningStatus Contains Provisioning errors
 */
public data class ProvisionedClustersCommonPropertiesResponseStatus(
    public val addonStatus: Map<String, AddonStatusResponse>? = null,
    public val errorMessage: String? = null,
    public val featuresStatus: ProvisionedClustersCommonPropertiesResponseFeaturesStatus? = null,
    public val provisioningStatus: ProvisionedClustersCommonPropertiesResponseProvisioningStatus? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.ProvisionedClustersCommonPropertiesResponseStatus):
            ProvisionedClustersCommonPropertiesResponseStatus =
            ProvisionedClustersCommonPropertiesResponseStatus(
                addonStatus = javaType.addonStatus().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AddonStatusResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
                featuresStatus = javaType.featuresStatus().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersCommonPropertiesResponseFeaturesStatus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersCommonPropertiesResponseProvisioningStatus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
