@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Infra network profile for VMware platform
 * @property segmentName Name of the network segment in VSphere
 */
public data class VirtualNetworksPropertiesResponseVmware(
    public val segmentName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.VirtualNetworksPropertiesResponseVmware):
            VirtualNetworksPropertiesResponseVmware = VirtualNetworksPropertiesResponseVmware(
            segmentName = javaType.segmentName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
