@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.inputs

import com.pulumi.azurenative.hybriddata.inputs.GetJobDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property dataServiceName The data service name of the job definition
 * @property jobDefinitionName The job definition name that is being queried.
 * @property resourceGroupName The Resource Group Name
 */
public data class GetJobDefinitionPlainArgs(
    public val dataManagerName: String,
    public val dataServiceName: String,
    public val jobDefinitionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.inputs.GetJobDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.inputs.GetJobDefinitionPlainArgs =
        com.pulumi.azurenative.hybriddata.inputs.GetJobDefinitionPlainArgs.builder()
            .dataManagerName(dataManagerName.let({ args0 -> args0 }))
            .dataServiceName(dataServiceName.let({ args0 -> args0 }))
            .jobDefinitionName(jobDefinitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetJobDefinitionPlainArgsBuilder internal constructor() {
    private var dataManagerName: String? = null

    private var dataServiceName: String? = null

    private var jobDefinitionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("dxwyxbbfnekiydsa")
    public suspend fun dataManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerName = mapped
    }

    /**
     * @param value The data service name of the job definition
     */
    @JvmName("ahdhrsrdirvpypht")
    public suspend fun dataServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataServiceName = mapped
    }

    /**
     * @param value The job definition name that is being queried.
     */
    @JvmName("tafluupomridfmew")
    public suspend fun jobDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobDefinitionName = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("muybjduaapfdhbmf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobDefinitionPlainArgs = GetJobDefinitionPlainArgs(
        dataManagerName = dataManagerName ?: throw PulumiNullFieldException("dataManagerName"),
        dataServiceName = dataServiceName ?: throw PulumiNullFieldException("dataServiceName"),
        jobDefinitionName = jobDefinitionName ?: throw PulumiNullFieldException("jobDefinitionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
