@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data store.
 * @property customerSecrets List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
 * @property dataStoreTypeId The arm id of the data store type.
 * @property extendedProperties A generic json used differently by each data source type.
 * @property id Id of the object.
 * @property name Name of the object.
 * @property repositoryId Arm Id for the manager resource to which the data source is associated. This is optional.
 * @property state State of the data source.
 * @property type Type of the object.
 */
public data class GetDataStoreResult(
    public val customerSecrets: List<CustomerSecretResponse>? = null,
    public val dataStoreTypeId: String,
    public val extendedProperties: Any? = null,
    public val id: String,
    public val name: String,
    public val repositoryId: String? = null,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.outputs.GetDataStoreResult):
            GetDataStoreResult = GetDataStoreResult(
            customerSecrets = javaType.customerSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybriddata.kotlin.outputs.CustomerSecretResponse.Companion.toKotlin(args0)
                })
            }),
            dataStoreTypeId = javaType.dataStoreTypeId(),
            extendedProperties = javaType.extendedProperties().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            repositoryId = javaType.repositoryId().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
