@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The sku type.
 * @property name The sku name. Required for data manager creation, optional for update.
 * @property tier The sku tier. This is based on the SKU name.
 */
public data class SkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
