@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchemaArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ConfigurationGroupSchemaPropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ConfigurationGroupSchemaPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Configuration group schema resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the network function definition group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationGroupSchema = new AzureNative.HybridNetwork.ConfigurationGroupSchema("configurationGroupSchema", new()
 *     {
 *         ConfigurationGroupSchemaName = "testConfigurationGroupSchema",
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ConfigurationGroupSchemaPropertiesFormatArgs
 *         {
 *             Description = "Schema with no secrets",
 *             SchemaDefinition = "{\"type\":\"object\",\"properties\":{\"interconnect-groups\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"},\"international-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}},\"domestic-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}}}}},\"interconnect-group-assignments\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"ssc\":{\"type\":\"string\"},\"interconnects-interconnects\":{\"type\":\"string\"}}}}},\"required\":[\"interconnect-groups\",\"interconnect-group-assignments\"]}",
 *         },
 *         PublisherName = "testPublisher",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewConfigurationGroupSchema(ctx, "configurationGroupSchema", &hybridnetwork.ConfigurationGroupSchemaArgs{
 * 			ConfigurationGroupSchemaName: pulumi.String("testConfigurationGroupSchema"),
 * 			Location:                     pulumi.String("westUs2"),
 * 			Properties: &hybridnetwork.ConfigurationGroupSchemaPropertiesFormatArgs{
 * 				Description:      pulumi.String("Schema with no secrets"),
 * 				SchemaDefinition: pulumi.String("{\"type\":\"object\",\"properties\":{\"interconnect-groups\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"},\"international-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}},\"domestic-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}}}}},\"interconnect-group-assignments\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"ssc\":{\"type\":\"string\"},\"interconnects-interconnects\":{\"type\":\"string\"}}}}},\"required\":[\"interconnect-groups\",\"interconnect-group-assignments\"]}"),
 * 			},
 * 			PublisherName:     pulumi.String("testPublisher"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchema;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationGroupSchema = new ConfigurationGroupSchema("configurationGroupSchema", ConfigurationGroupSchemaArgs.builder()
 *             .configurationGroupSchemaName("testConfigurationGroupSchema")
 *             .location("westUs2")
 *             .properties(Map.ofEntries(
 *                 Map.entry("description", "Schema with no secrets"),
 *                 Map.entry("schemaDefinition", "{\"type\":\"object\",\"properties\":{\"interconnect-groups\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"},\"international-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}},\"domestic-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}}}}},\"interconnect-group-assignments\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"ssc\":{\"type\":\"string\"},\"interconnects-interconnects\":{\"type\":\"string\"}}}}},\"required\":[\"interconnect-groups\",\"interconnect-group-assignments\"]}")
 *             ))
 *             .publisherName("testPublisher")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ConfigurationGroupSchema testConfigurationGroupSchema /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}
 * ```
 * @property configurationGroupSchemaName The name of the configuration group schema.
 * @property location The geo-location where the resource lives
 * @property properties Configuration group schema properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ConfigurationGroupSchemaArgs(
    public val configurationGroupSchemaName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ConfigurationGroupSchemaPropertiesFormatArgs>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchemaArgs =
        com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchemaArgs.builder()
            .configurationGroupSchemaName(configurationGroupSchemaName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationGroupSchemaArgs].
 */
@PulumiTagMarker
public class ConfigurationGroupSchemaArgsBuilder internal constructor() {
    private var configurationGroupSchemaName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ConfigurationGroupSchemaPropertiesFormatArgs>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the configuration group schema.
     */
    @JvmName("pgifubpqchksvtld")
    public suspend fun configurationGroupSchemaName(`value`: Output<String>) {
        this.configurationGroupSchemaName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pevqjbuonfnrklgf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Configuration group schema properties.
     */
    @JvmName("tlslybgbpnhayqsg")
    public suspend fun properties(`value`: Output<ConfigurationGroupSchemaPropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("cxpomeigcuwkaerg")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hpnkyhahgsjdtxpw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fwardheydtsrpgdn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the configuration group schema.
     */
    @JvmName("smcpisomaayhtgey")
    public suspend fun configurationGroupSchemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationGroupSchemaName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ruhahxqsgxiagihf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Configuration group schema properties.
     */
    @JvmName("jgaibhccktvrgvba")
    public suspend fun properties(`value`: ConfigurationGroupSchemaPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Configuration group schema properties.
     */
    @JvmName("qytuwhvuclhtixtr")
    public suspend
    fun properties(argument: suspend ConfigurationGroupSchemaPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationGroupSchemaPropertiesFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("anqdshnnbncmlrjs")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qqrvqbheuqmqujgw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cyspbicjaxicveyk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("isqqctaftcvunkwl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationGroupSchemaArgs = ConfigurationGroupSchemaArgs(
        configurationGroupSchemaName = configurationGroupSchemaName,
        location = location,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
