@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroupArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkFunctionDefinitionGroupPropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkFunctionDefinitionGroupPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network function definition group resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the network function definition group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionGroup = new AzureNative.HybridNetwork.NetworkFunctionDefinitionGroup("networkFunctionDefinitionGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionGroup(ctx, "networkFunctionDefinitionGroup", &hybridnetwork.NetworkFunctionDefinitionGroupArgs{
 * 			Location:                           pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName: pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			PublisherName:                      pulumi.String("TestPublisher"),
 * 			ResourceGroupName:                  pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroup;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionGroup = new NetworkFunctionDefinitionGroup("networkFunctionDefinitionGroup", NetworkFunctionDefinitionGroupArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkFunctionDefinitionGroup TestPublisherSkuVersion /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkFunctionDefinitionGroups/{networkFunctionDefinitionGroupName}
 * ```
 * @property location The geo-location where the resource lives
 * @property networkFunctionDefinitionGroupName The name of the network function definition group.
 * @property properties Network function definition group properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkFunctionDefinitionGroupArgs(
    public val location: Output<String>? = null,
    public val networkFunctionDefinitionGroupName: Output<String>? = null,
    public val properties: Output<NetworkFunctionDefinitionGroupPropertiesFormatArgs>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroupArgs =
        com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroupArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFunctionDefinitionGroupName(
                networkFunctionDefinitionGroupName?.applyValue({ args0 ->
                    args0
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkFunctionDefinitionGroupArgs].
 */
@PulumiTagMarker
public class NetworkFunctionDefinitionGroupArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var networkFunctionDefinitionGroupName: Output<String>? = null

    private var properties: Output<NetworkFunctionDefinitionGroupPropertiesFormatArgs>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qomvmwytxgqxrsjg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network function definition group.
     */
    @JvmName("dnraoichakxuvpnv")
    public suspend fun networkFunctionDefinitionGroupName(`value`: Output<String>) {
        this.networkFunctionDefinitionGroupName = value
    }

    /**
     * @param value Network function definition group properties.
     */
    @JvmName("sqvykcjrsenqgyac")
    public suspend
    fun properties(`value`: Output<NetworkFunctionDefinitionGroupPropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("mukqqbrihblkcfqg")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("risfnfipcjevsuit")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iakhonsptndqbotr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mwgakyncsfcqyubk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network function definition group.
     */
    @JvmName("avebisqhowtuauux")
    public suspend fun networkFunctionDefinitionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionDefinitionGroupName = mapped
    }

    /**
     * @param value Network function definition group properties.
     */
    @JvmName("cpghukhcronxpjii")
    public suspend fun properties(`value`: NetworkFunctionDefinitionGroupPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Network function definition group properties.
     */
    @JvmName("lcxbljbpvcekyyuv")
    public suspend
    fun properties(argument: suspend NetworkFunctionDefinitionGroupPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkFunctionDefinitionGroupPropertiesFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("yyfrhspjisbqnikl")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("flsosfopofocwmol")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aldraewnppvinqfb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("yiebygxeqbcfqtyb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkFunctionDefinitionGroupArgs = NetworkFunctionDefinitionGroupArgs(
        location = location,
        networkFunctionDefinitionGroupName = networkFunctionDefinitionGroupName,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
