@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersionArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkServiceDesignVersionPropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkServiceDesignVersionPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * network service design version.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update a network service design version resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkServiceDesignVersion = new AzureNative.HybridNetwork.NetworkServiceDesignVersion("networkServiceDesignVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkServiceDesignGroupName = "TestNetworkServiceDesignGroupName",
 *         NetworkServiceDesignVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.NetworkServiceDesignVersionPropertiesFormatArgs
 *         {
 *             ConfigurationGroupSchemaReferences =
 *             {
 *                 { "MyVM_Configuration", new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/publishers/contosoGroup/networkServiceDesignGroups/NSD_contoso/configurationGroupSchemas/MyVM_Configuration_Schema",
 *                 } },
 *             },
 *             ResourceElementTemplates = new[]
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.ArmResourceDefinitionResourceElementTemplateDetailsArgs
 *                 {
 *                     Configuration = new AzureNative.HybridNetwork.Inputs.ArmResourceDefinitionResourceElementTemplateArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.NSDArtifactProfileArgs
 *                         {
 *                             ArtifactName = "MyVMArmTemplate",
 *                             ArtifactStoreReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/providers/Microsoft.HybridNetwork/publishers/contosoGroup/artifactStoreReference/store1",
 *                             },
 *                             ArtifactVersion = "1.0.0",
 *                         },
 *                         ParameterValues = "{\"publisherName\":\"{configurationparameters('MyVM_Configuration').publisherName}\",\"skuGroupName\":\"{configurationparameters('MyVM_Configuration').skuGroupName}\",\"skuVersion\":\"{configurationparameters('MyVM_Configuration').skuVersion}\",\"skuOfferingLocation\":\"{configurationparameters('MyVM_Configuration').skuOfferingLocation}\",\"nfviType\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviType}\",\"nfviId\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviId}\",\"allowSoftwareUpdates\":\"{configurationparameters('MyVM_Configuration').allowSoftwareUpdates}\",\"virtualNetworkName\":\"{configurationparameters('MyVM_Configuration').vnetName}\",\"subnetName\":\"{configurationparameters('MyVM_Configuration').subnetName}\",\"subnetAddressPrefix\":\"{configurationparameters('MyVM_Configuration').subnetAddressPrefix}\",\"managedResourceGroup\":\"{configurationparameters('SNSSelf').managedResourceGroupName}\",\"adminPassword\":\"{secretparameters('MyVM_Configuration').adminPassword}\"}",
 *                         TemplateType = "ArmTemplate",
 *                     },
 *                     DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                     {
 *                         InstallDependsOn = new() { },
 *                     },
 *                     Name = "MyVM",
 *                     ResourceElementType = "ArmResourceDefinition",
 *                 },
 *             },
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkServiceDesignVersion(ctx, "networkServiceDesignVersion", &hybridnetwork.NetworkServiceDesignVersionArgs{
 * 			Location:                        pulumi.String("eastus"),
 * 			NetworkServiceDesignGroupName:   pulumi.String("TestNetworkServiceDesignGroupName"),
 * 			NetworkServiceDesignVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.NetworkServiceDesignVersionPropertiesFormatResponse{
 * 				ConfigurationGroupSchemaReferences: hybridnetwork.ReferencedResourceMap{
 * 					"MyVM_Configuration": &hybridnetwork.ReferencedResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/publishers/contosoGroup/networkServiceDesignGroups/NSD_contoso/configurationGroupSchemas/MyVM_Configuration_Schema"),
 * 					},
 * 				},
 * 				ResourceElementTemplates: pulumi.Array{
 * 					hybridnetwork.ArmResourceDefinitionResourceElementTemplateDetails{
 * 						Configuration: hybridnetwork.ArmResourceDefinitionResourceElementTemplate{
 * 							ArtifactProfile: hybridnetwork.NSDArtifactProfile{
 * 								ArtifactName: "MyVMArmTemplate",
 * 								ArtifactStoreReference: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/providers/Microsoft.HybridNetwork/publishers/contosoGroup/artifactStoreReference/store1",
 * 								},
 * 								ArtifactVersion: "1.0.0",
 * 							},
 * 							ParameterValues: "{\"publisherName\":\"{configurationparameters('MyVM_Configuration').publisherName}\",\"skuGroupName\":\"{configurationparameters('MyVM_Configuration').skuGroupName}\",\"skuVersion\":\"{configurationparameters('MyVM_Configuration').skuVersion}\",\"skuOfferingLocation\":\"{configurationparameters('MyVM_Configuration').skuOfferingLocation}\",\"nfviType\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviType}\",\"nfviId\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviId}\",\"allowSoftwareUpdates\":\"{configurationparameters('MyVM_Configuration').allowSoftwareUpdates}\",\"virtualNetworkName\":\"{configurationparameters('MyVM_Configuration').vnetName}\",\"subnetName\":\"{configurationparameters('MyVM_Configuration').subnetName}\",\"subnetAddressPrefix\":\"{configurationparameters('MyVM_Configuration').subnetAddressPrefix}\",\"managedResourceGroup\":\"{configurationparameters('SNSSelf').managedResourceGroupName}\",\"adminPassword\":\"{secretparameters('MyVM_Configuration').adminPassword}\"}",
 * 							TemplateType:    "ArmTemplate",
 * 						},
 * 						DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 							InstallDependsOn: []interface{}{},
 * 						},
 * 						Name:                "MyVM",
 * 						ResourceElementType: "ArmResourceDefinition",
 * 					},
 * 				},
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkServiceDesignVersion = new NetworkServiceDesignVersion("networkServiceDesignVersion", NetworkServiceDesignVersionArgs.builder()
 *             .location("eastus")
 *             .networkServiceDesignGroupName("TestNetworkServiceDesignGroupName")
 *             .networkServiceDesignVersionName("1.0.0")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configurationGroupSchemaReferences", Map.of("MyVM_Configuration", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/publishers/contosoGroup/networkServiceDesignGroups/NSD_contoso/configurationGroupSchemas/MyVM_Configuration_Schema"))),
 *                 Map.entry("resourceElementTemplates", Map.ofEntries(
 *                     Map.entry("configuration", Map.ofEntries(
 *                         Map.entry("artifactProfile", Map.ofEntries(
 *                             Map.entry("artifactName", "MyVMArmTemplate"),
 *                             Map.entry("artifactStoreReference", Map.of("id", "/subscriptions/subid/providers/Microsoft.HybridNetwork/publishers/contosoGroup/artifactStoreReference/store1")),
 *                             Map.entry("artifactVersion", "1.0.0")
 *                         )),
 *                         Map.entry("parameterValues", "{\"publisherName\":\"{configurationparameters('MyVM_Configuration').publisherName}\",\"skuGroupName\":\"{configurationparameters('MyVM_Configuration').skuGroupName}\",\"skuVersion\":\"{configurationparameters('MyVM_Configuration').skuVersion}\",\"skuOfferingLocation\":\"{configurationparameters('MyVM_Configuration').skuOfferingLocation}\",\"nfviType\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviType}\",\"nfviId\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviId}\",\"allowSoftwareUpdates\":\"{configurationparameters('MyVM_Configuration').allowSoftwareUpdates}\",\"virtualNetworkName\":\"{configurationparameters('MyVM_Configuration').vnetName}\",\"subnetName\":\"{configurationparameters('MyVM_Configuration').subnetName}\",\"subnetAddressPrefix\":\"{configurationparameters('MyVM_Configuration').subnetAddressPrefix}\",\"managedResourceGroup\":\"{configurationparameters('SNSSelf').managedResourceGroupName}\",\"adminPassword\":\"{secretparameters('MyVM_Configuration').adminPassword}\"}"),
 *                         Map.entry("templateType", "ArmTemplate")
 *                     )),
 *                     Map.entry("dependsOnProfile", Map.of("installDependsOn", )),
 *                     Map.entry("name", "MyVM"),
 *                     Map.entry("resourceElementType", "ArmResourceDefinition")
 *                 ))
 *             ))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkServiceDesignVersion TestVersion /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkServiceDesignGroups/{networkServiceDesignGroupName}/networkServiceDesignVersions/{networkServiceDesignVersionName}
 * ```
 * @property location The geo-location where the resource lives
 * @property networkServiceDesignGroupName The name of the network service design group.
 * @property networkServiceDesignVersionName The name of the network service design version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
 * @property properties network service design version properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkServiceDesignVersionArgs(
    public val location: Output<String>? = null,
    public val networkServiceDesignGroupName: Output<String>? = null,
    public val networkServiceDesignVersionName: Output<String>? = null,
    public val properties: Output<NetworkServiceDesignVersionPropertiesFormatArgs>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersionArgs =
        com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersionArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .networkServiceDesignGroupName(networkServiceDesignGroupName?.applyValue({ args0 -> args0 }))
            .networkServiceDesignVersionName(networkServiceDesignVersionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkServiceDesignVersionArgs].
 */
@PulumiTagMarker
public class NetworkServiceDesignVersionArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var networkServiceDesignGroupName: Output<String>? = null

    private var networkServiceDesignVersionName: Output<String>? = null

    private var properties: Output<NetworkServiceDesignVersionPropertiesFormatArgs>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("khthgqlgplaenqfd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network service design group.
     */
    @JvmName("cmkrcfcnqlyddobw")
    public suspend fun networkServiceDesignGroupName(`value`: Output<String>) {
        this.networkServiceDesignGroupName = value
    }

    /**
     * @param value The name of the network service design version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     */
    @JvmName("wbbhrudkkisurcfd")
    public suspend fun networkServiceDesignVersionName(`value`: Output<String>) {
        this.networkServiceDesignVersionName = value
    }

    /**
     * @param value network service design version properties.
     */
    @JvmName("fnxyixfjomjkouxj")
    public suspend fun properties(`value`: Output<NetworkServiceDesignVersionPropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("kingabcgmymhnyhe")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dekylulijjsnxjfe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cwuwujcshfrikxtr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("napeksyqkgrvwkbd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network service design group.
     */
    @JvmName("hawspoxiavkauuyh")
    public suspend fun networkServiceDesignGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkServiceDesignGroupName = mapped
    }

    /**
     * @param value The name of the network service design version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     */
    @JvmName("kmdljubkmmmcvmuw")
    public suspend fun networkServiceDesignVersionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkServiceDesignVersionName = mapped
    }

    /**
     * @param value network service design version properties.
     */
    @JvmName("bgcpxidylavomxdu")
    public suspend fun properties(`value`: NetworkServiceDesignVersionPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument network service design version properties.
     */
    @JvmName("ertjpqgnxyejpjwh")
    public suspend
    fun properties(argument: suspend NetworkServiceDesignVersionPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkServiceDesignVersionPropertiesFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("jxwgnronhlifblcc")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("unsjyjaeettnwoxy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ujbrxxlffutwrcnk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tnwsvncanrpehnyk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkServiceDesignVersionArgs = NetworkServiceDesignVersionArgs(
        location = location,
        networkServiceDesignGroupName = networkServiceDesignGroupName,
        networkServiceDesignVersionName = networkServiceDesignVersionName,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
