@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ArmResourceDefinitionResourceElementTemplateArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.TemplateType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The arm template RE.
 * @property artifactProfile Artifact profile properties.
 * @property parameterValues Name and value pairs that define the parameter values. It can be  a well formed escaped JSON string.
 * @property templateType The template type.
 */
public data class ArmResourceDefinitionResourceElementTemplateArgs(
    public val artifactProfile: Output<NSDArtifactProfileArgs>? = null,
    public val parameterValues: Output<String>? = null,
    public val templateType: Output<Either<String, TemplateType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ArmResourceDefinitionResourceElementTemplateArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ArmResourceDefinitionResourceElementTemplateArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ArmResourceDefinitionResourceElementTemplateArgs.builder()
            .artifactProfile(artifactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameterValues(parameterValues?.applyValue({ args0 -> args0 }))
            .templateType(
                templateType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ArmResourceDefinitionResourceElementTemplateArgs].
 */
@PulumiTagMarker
public class ArmResourceDefinitionResourceElementTemplateArgsBuilder internal constructor() {
    private var artifactProfile: Output<NSDArtifactProfileArgs>? = null

    private var parameterValues: Output<String>? = null

    private var templateType: Output<Either<String, TemplateType>>? = null

    /**
     * @param value Artifact profile properties.
     */
    @JvmName("bcdayvvnldcdirjd")
    public suspend fun artifactProfile(`value`: Output<NSDArtifactProfileArgs>) {
        this.artifactProfile = value
    }

    /**
     * @param value Name and value pairs that define the parameter values. It can be  a well formed escaped JSON string.
     */
    @JvmName("kwuxaumblghsfcsj")
    public suspend fun parameterValues(`value`: Output<String>) {
        this.parameterValues = value
    }

    /**
     * @param value The template type.
     */
    @JvmName("bhaevhkobwopyxog")
    public suspend fun templateType(`value`: Output<Either<String, TemplateType>>) {
        this.templateType = value
    }

    /**
     * @param value Artifact profile properties.
     */
    @JvmName("hanljakigsscmjct")
    public suspend fun artifactProfile(`value`: NSDArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactProfile = mapped
    }

    /**
     * @param argument Artifact profile properties.
     */
    @JvmName("tthindidregdfhjg")
    public suspend fun artifactProfile(argument: suspend NSDArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NSDArtifactProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactProfile = mapped
    }

    /**
     * @param value Name and value pairs that define the parameter values. It can be  a well formed escaped JSON string.
     */
    @JvmName("ynokuubcrbipnsya")
    public suspend fun parameterValues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param value The template type.
     */
    @JvmName("okgkvnuidavsqhsg")
    public suspend fun templateType(`value`: Either<String, TemplateType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateType = mapped
    }

    /**
     * @param value The template type.
     */
    @JvmName("snmapvgtfhqdtarx")
    public fun templateType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TemplateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateType = mapped
    }

    /**
     * @param value The template type.
     */
    @JvmName("pglpnfphureoxogh")
    public fun templateType(`value`: TemplateType) {
        val toBeMapped = Either.ofRight<String, TemplateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateType = mapped
    }

    internal fun build(): ArmResourceDefinitionResourceElementTemplateArgs =
        ArmResourceDefinitionResourceElementTemplateArgs(
            artifactProfile = artifactProfile,
            parameterValues = parameterValues,
            templateType = templateType,
        )
}
