@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure arc kubernetes artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property helmArtifactProfile Helm artifact profile.
 */
public data class AzureArcKubernetesArtifactProfileArgs(
    public val artifactStore: Output<ReferencedResourceArgs>? = null,
    public val helmArtifactProfile: Output<HelmArtifactProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesArtifactProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesArtifactProfileArgs.builder()
            .artifactStore(artifactStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .helmArtifactProfile(
                helmArtifactProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureArcKubernetesArtifactProfileArgs].
 */
@PulumiTagMarker
public class AzureArcKubernetesArtifactProfileArgsBuilder internal constructor() {
    private var artifactStore: Output<ReferencedResourceArgs>? = null

    private var helmArtifactProfile: Output<HelmArtifactProfileArgs>? = null

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("gputfxcsrnlwuubb")
    public suspend fun artifactStore(`value`: Output<ReferencedResourceArgs>) {
        this.artifactStore = value
    }

    /**
     * @param value Helm artifact profile.
     */
    @JvmName("ibufuaceqyrughds")
    public suspend fun helmArtifactProfile(`value`: Output<HelmArtifactProfileArgs>) {
        this.helmArtifactProfile = value
    }

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("njxauubyxobifoth")
    public suspend fun artifactStore(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStore = mapped
    }

    /**
     * @param argument The reference to artifact store.
     */
    @JvmName("camgykplvcrhjbpx")
    public suspend fun artifactStore(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactStore = mapped
    }

    /**
     * @param value Helm artifact profile.
     */
    @JvmName("nfqnslqpjbiwiimj")
    public suspend fun helmArtifactProfile(`value`: HelmArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmArtifactProfile = mapped
    }

    /**
     * @param argument Helm artifact profile.
     */
    @JvmName("aexqudktyhwchykc")
    public suspend
    fun helmArtifactProfile(argument: suspend HelmArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HelmArtifactProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.helmArtifactProfile = mapped
    }

    internal fun build(): AzureArcKubernetesArtifactProfileArgs =
        AzureArcKubernetesArtifactProfileArgs(
            artifactStore = artifactStore,
            helmArtifactProfile = helmArtifactProfile,
        )
}
