@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesDeployMappingRuleProfileArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ApplicationEnablement
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure arc kubernetes deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property helmMappingRuleProfile The helm mapping rule profile.
 */
public data class AzureArcKubernetesDeployMappingRuleProfileArgs(
    public val applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null,
    public val helmMappingRuleProfile: Output<HelmMappingRuleProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesDeployMappingRuleProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesDeployMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesDeployMappingRuleProfileArgs.builder()
            .applicationEnablement(
                applicationEnablement?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .helmMappingRuleProfile(
                helmMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureArcKubernetesDeployMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class AzureArcKubernetesDeployMappingRuleProfileArgsBuilder internal constructor() {
    private var applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null

    private var helmMappingRuleProfile: Output<HelmMappingRuleProfileArgs>? = null

    /**
     * @param value The application enablement.
     */
    @JvmName("acgvgfkkpljbwfov")
    public suspend fun applicationEnablement(`value`: Output<Either<String, ApplicationEnablement>>) {
        this.applicationEnablement = value
    }

    /**
     * @param value The helm mapping rule profile.
     */
    @JvmName("xslguxxwcddoeyrf")
    public suspend fun helmMappingRuleProfile(`value`: Output<HelmMappingRuleProfileArgs>) {
        this.helmMappingRuleProfile = value
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("shnsixsodbopjtxp")
    public suspend fun applicationEnablement(`value`: Either<String, ApplicationEnablement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("bscucgkplhrbkrnj")
    public fun applicationEnablement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("rlxdiglpplrmhmps")
    public fun applicationEnablement(`value`: ApplicationEnablement) {
        val toBeMapped = Either.ofRight<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The helm mapping rule profile.
     */
    @JvmName("jfbqcnuyrspumbuv")
    public suspend fun helmMappingRuleProfile(`value`: HelmMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmMappingRuleProfile = mapped
    }

    /**
     * @param argument The helm mapping rule profile.
     */
    @JvmName("dhrcnyuaqvuojrlq")
    public suspend
    fun helmMappingRuleProfile(argument: suspend HelmMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HelmMappingRuleProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.helmMappingRuleProfile = mapped
    }

    internal fun build(): AzureArcKubernetesDeployMappingRuleProfileArgs =
        AzureArcKubernetesDeployMappingRuleProfileArgs(
            applicationEnablement = applicationEnablement,
            helmMappingRuleProfile = helmMappingRuleProfile,
        )
}
