@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreArmTemplateDeployMappingRuleProfileArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ApplicationEnablement
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure template deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property templateMappingRuleProfile The template mapping rule profile.
 */
public data class AzureCoreArmTemplateDeployMappingRuleProfileArgs(
    public val applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null,
    public val templateMappingRuleProfile: Output<ArmTemplateMappingRuleProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreArmTemplateDeployMappingRuleProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreArmTemplateDeployMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreArmTemplateDeployMappingRuleProfileArgs.builder()
            .applicationEnablement(
                applicationEnablement?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .templateMappingRuleProfile(
                templateMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureCoreArmTemplateDeployMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class AzureCoreArmTemplateDeployMappingRuleProfileArgsBuilder internal constructor() {
    private var applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null

    private var templateMappingRuleProfile: Output<ArmTemplateMappingRuleProfileArgs>? = null

    /**
     * @param value The application enablement.
     */
    @JvmName("dkcdrywdgbufggls")
    public suspend fun applicationEnablement(`value`: Output<Either<String, ApplicationEnablement>>) {
        this.applicationEnablement = value
    }

    /**
     * @param value The template mapping rule profile.
     */
    @JvmName("bujahlnutaqnqouv")
    public suspend
    fun templateMappingRuleProfile(`value`: Output<ArmTemplateMappingRuleProfileArgs>) {
        this.templateMappingRuleProfile = value
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("fanakwkitqcstjpl")
    public suspend fun applicationEnablement(`value`: Either<String, ApplicationEnablement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("fmemkwymbbwykxfa")
    public fun applicationEnablement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("wklhxqdroqtfxrio")
    public fun applicationEnablement(`value`: ApplicationEnablement) {
        val toBeMapped = Either.ofRight<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The template mapping rule profile.
     */
    @JvmName("otehtoanvpscettx")
    public suspend fun templateMappingRuleProfile(`value`: ArmTemplateMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateMappingRuleProfile = mapped
    }

    /**
     * @param argument The template mapping rule profile.
     */
    @JvmName("wcqbcrywnoiwbrpw")
    public suspend
    fun templateMappingRuleProfile(argument: suspend ArmTemplateMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ArmTemplateMappingRuleProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateMappingRuleProfile = mapped
    }

    internal fun build(): AzureCoreArmTemplateDeployMappingRuleProfileArgs =
        AzureCoreArmTemplateDeployMappingRuleProfileArgs(
            applicationEnablement = applicationEnablement,
            templateMappingRuleProfile = templateMappingRuleProfile,
        )
}
