@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionTemplateArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure virtual network function template.
 * @property networkFunctionApplications Network function applications.
 * @property nfviType The network function type.
 * Expected value is 'AzureCore'.
 */
public data class AzureCoreNetworkFunctionTemplateArgs(
    public val networkFunctionApplications:
    Output<List<Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>>>? =
        null,
    public val nfviType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionTemplateArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionTemplateArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionTemplateArgs.builder()
            .networkFunctionApplications(
                networkFunctionApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .nfviType(nfviType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureCoreNetworkFunctionTemplateArgs].
 */
@PulumiTagMarker
public class AzureCoreNetworkFunctionTemplateArgsBuilder internal constructor() {
    private var networkFunctionApplications:
        Output<List<Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>>>? =
        null

    private var nfviType: Output<String>? = null

    /**
     * @param value Network function applications.
     */
    @JvmName("hdiaytuykxufjurr")
    public suspend
    fun networkFunctionApplications(`value`: Output<List<Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>>>) {
        this.networkFunctionApplications = value
    }

    @JvmName("qtcrlfibjbbkiqgi")
    public suspend fun networkFunctionApplications(
        vararg
        values: Output<Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>>,
    ) {
        this.networkFunctionApplications = Output.all(values.asList())
    }

    /**
     * @param values Network function applications.
     */
    @JvmName("fsfcqpgpeqailgrd")
    public suspend
    fun networkFunctionApplications(values: List<Output<Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>>>) {
        this.networkFunctionApplications = Output.all(values)
    }

    /**
     * @param value The network function type.
     * Expected value is 'AzureCore'.
     */
    @JvmName("yperoghcaongmrbq")
    public suspend fun nfviType(`value`: Output<String>) {
        this.nfviType = value
    }

    /**
     * @param value Network function applications.
     */
    @JvmName("rikxdaifyxhdukgi")
    public suspend
    fun networkFunctionApplications(`value`: List<Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionApplications = mapped
    }

    /**
     * @param values Network function applications.
     */
    @JvmName("axjpwyvolocxhdge")
    public suspend fun networkFunctionApplications(
        vararg
        values: Either<AzureCoreNetworkFunctionArmTemplateApplicationArgs, AzureCoreNetworkFunctionVhdApplicationArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionApplications = mapped
    }

    /**
     * @param value The network function type.
     * Expected value is 'AzureCore'.
     */
    @JvmName("opqhjmeciygcoqmr")
    public suspend fun nfviType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfviType = mapped
    }

    internal fun build(): AzureCoreNetworkFunctionTemplateArgs = AzureCoreNetworkFunctionTemplateArgs(
        networkFunctionApplications = networkFunctionApplications,
        nfviType = nfviType ?: throw PulumiNullFieldException("nfviType"),
    )
}
