@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionVhdApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure core network function vhd application definition.
 * @property artifactProfile Azure vhd image artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'VhdImageFile'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureCoreNetworkFunctionVhdApplicationArgs(
    public val artifactProfile: Output<AzureCoreVhdImageArtifactProfileArgs>? = null,
    public val artifactType: Output<String>,
    public val dependsOnProfile: Output<DependsOnProfileArgs>? = null,
    public val deployParametersMappingRuleProfile:
    Output<AzureCoreVhdImageDeployMappingRuleProfileArgs>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionVhdApplicationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionVhdApplicationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionVhdApplicationArgs.builder()
            .artifactProfile(artifactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .artifactType(artifactType.applyValue({ args0 -> args0 }))
            .dependsOnProfile(dependsOnProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deployParametersMappingRuleProfile(
                deployParametersMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureCoreNetworkFunctionVhdApplicationArgs].
 */
@PulumiTagMarker
public class AzureCoreNetworkFunctionVhdApplicationArgsBuilder internal constructor() {
    private var artifactProfile: Output<AzureCoreVhdImageArtifactProfileArgs>? = null

    private var artifactType: Output<String>? = null

    private var dependsOnProfile: Output<DependsOnProfileArgs>? = null

    private var deployParametersMappingRuleProfile:
        Output<AzureCoreVhdImageDeployMappingRuleProfileArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure vhd image artifact profile.
     */
    @JvmName("decbfdmvcpetpkmh")
    public suspend fun artifactProfile(`value`: Output<AzureCoreVhdImageArtifactProfileArgs>) {
        this.artifactProfile = value
    }

    /**
     * @param value The artifact type.
     * Expected value is 'VhdImageFile'.
     */
    @JvmName("nafeokjsoiwfowll")
    public suspend fun artifactType(`value`: Output<String>) {
        this.artifactType = value
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("oadmlesadeqfhiyk")
    public suspend fun dependsOnProfile(`value`: Output<DependsOnProfileArgs>) {
        this.dependsOnProfile = value
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("masqpdpwewwxjhco")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: Output<AzureCoreVhdImageDeployMappingRuleProfileArgs>) {
        this.deployParametersMappingRuleProfile = value
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("ihycwxdjyyaupgwn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure vhd image artifact profile.
     */
    @JvmName("rgklolsfcdluuoia")
    public suspend fun artifactProfile(`value`: AzureCoreVhdImageArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactProfile = mapped
    }

    /**
     * @param argument Azure vhd image artifact profile.
     */
    @JvmName("bsnkjhbtaalqshys")
    public suspend
    fun artifactProfile(argument: suspend AzureCoreVhdImageArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureCoreVhdImageArtifactProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.artifactProfile = mapped
    }

    /**
     * @param value The artifact type.
     * Expected value is 'VhdImageFile'.
     */
    @JvmName("nbwggnigkgijmavt")
    public suspend fun artifactType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("ugvnplkmwcbvwvey")
    public suspend fun dependsOnProfile(`value`: DependsOnProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnProfile = mapped
    }

    /**
     * @param argument Depends on profile definition.
     */
    @JvmName("dxlrtokasamlliqs")
    public suspend fun dependsOnProfile(argument: suspend DependsOnProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DependsOnProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependsOnProfile = mapped
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("uwmisthqdrjkvkgw")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: AzureCoreVhdImageDeployMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param argument Deploy mapping rule profile.
     */
    @JvmName("mojcialkdpykfifs")
    public suspend
    fun deployParametersMappingRuleProfile(argument: suspend AzureCoreVhdImageDeployMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureCoreVhdImageDeployMappingRuleProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("bfhvdohnimsqtnta")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureCoreNetworkFunctionVhdApplicationArgs =
        AzureCoreNetworkFunctionVhdApplicationArgs(
            artifactProfile = artifactProfile,
            artifactType = artifactType ?: throw PulumiNullFieldException("artifactType"),
            dependsOnProfile = dependsOnProfile,
            deployParametersMappingRuleProfile = deployParametersMappingRuleProfile,
            name = name,
        )
}
