@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.DependsOnProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Depends on profile definition.
 * @property installDependsOn Application installation operation dependency.
 * @property uninstallDependsOn Application deletion operation dependency.
 * @property updateDependsOn Application update operation dependency.
 */
public data class DependsOnProfileArgs(
    public val installDependsOn: Output<List<String>>? = null,
    public val uninstallDependsOn: Output<List<String>>? = null,
    public val updateDependsOn: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.DependsOnProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.DependsOnProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.DependsOnProfileArgs.builder()
            .installDependsOn(installDependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .uninstallDependsOn(uninstallDependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .updateDependsOn(updateDependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DependsOnProfileArgs].
 */
@PulumiTagMarker
public class DependsOnProfileArgsBuilder internal constructor() {
    private var installDependsOn: Output<List<String>>? = null

    private var uninstallDependsOn: Output<List<String>>? = null

    private var updateDependsOn: Output<List<String>>? = null

    /**
     * @param value Application installation operation dependency.
     */
    @JvmName("klmadbebmdvysamu")
    public suspend fun installDependsOn(`value`: Output<List<String>>) {
        this.installDependsOn = value
    }

    @JvmName("qwqqwvyhejikdrij")
    public suspend fun installDependsOn(vararg values: Output<String>) {
        this.installDependsOn = Output.all(values.asList())
    }

    /**
     * @param values Application installation operation dependency.
     */
    @JvmName("vfutsjibetjuksen")
    public suspend fun installDependsOn(values: List<Output<String>>) {
        this.installDependsOn = Output.all(values)
    }

    /**
     * @param value Application deletion operation dependency.
     */
    @JvmName("jwnvonmtaufdmpxl")
    public suspend fun uninstallDependsOn(`value`: Output<List<String>>) {
        this.uninstallDependsOn = value
    }

    @JvmName("gavjjfyuvupigdej")
    public suspend fun uninstallDependsOn(vararg values: Output<String>) {
        this.uninstallDependsOn = Output.all(values.asList())
    }

    /**
     * @param values Application deletion operation dependency.
     */
    @JvmName("rbgarkggatrylisn")
    public suspend fun uninstallDependsOn(values: List<Output<String>>) {
        this.uninstallDependsOn = Output.all(values)
    }

    /**
     * @param value Application update operation dependency.
     */
    @JvmName("qibdxaaemeafjugp")
    public suspend fun updateDependsOn(`value`: Output<List<String>>) {
        this.updateDependsOn = value
    }

    @JvmName("apaqhtcmddilnrol")
    public suspend fun updateDependsOn(vararg values: Output<String>) {
        this.updateDependsOn = Output.all(values.asList())
    }

    /**
     * @param values Application update operation dependency.
     */
    @JvmName("lyqkecvusdltoorf")
    public suspend fun updateDependsOn(values: List<Output<String>>) {
        this.updateDependsOn = Output.all(values)
    }

    /**
     * @param value Application installation operation dependency.
     */
    @JvmName("apbcfxgmmgrqhuit")
    public suspend fun installDependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installDependsOn = mapped
    }

    /**
     * @param values Application installation operation dependency.
     */
    @JvmName("bqxyywnsmpjbhloo")
    public suspend fun installDependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.installDependsOn = mapped
    }

    /**
     * @param value Application deletion operation dependency.
     */
    @JvmName("ddrqvfejkhulhltu")
    public suspend fun uninstallDependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uninstallDependsOn = mapped
    }

    /**
     * @param values Application deletion operation dependency.
     */
    @JvmName("ggalgnqpidxnmoar")
    public suspend fun uninstallDependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uninstallDependsOn = mapped
    }

    /**
     * @param value Application update operation dependency.
     */
    @JvmName("hhsjdspdtanqympl")
    public suspend fun updateDependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateDependsOn = mapped
    }

    /**
     * @param values Application update operation dependency.
     */
    @JvmName("ttgwndoclgyqsqji")
    public suspend fun updateDependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updateDependsOn = mapped
    }

    internal fun build(): DependsOnProfileArgs = DependsOnProfileArgs(
        installDependsOn = installDependsOn,
        uninstallDependsOn = uninstallDependsOn,
        updateDependsOn = updateDependsOn,
    )
}
