@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkServiceDesignGroupName The name of the network service design group.
 * @property networkServiceDesignVersionName The name of the network service design version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkServiceDesignVersionPlainArgs(
    public val networkServiceDesignGroupName: String,
    public val networkServiceDesignVersionName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignVersionPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkServiceDesignVersionPlainArgs.builder()
            .networkServiceDesignGroupName(networkServiceDesignGroupName.let({ args0 -> args0 }))
            .networkServiceDesignVersionName(networkServiceDesignVersionName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkServiceDesignVersionPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkServiceDesignVersionPlainArgsBuilder internal constructor() {
    private var networkServiceDesignGroupName: String? = null

    private var networkServiceDesignVersionName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network service design group.
     */
    @JvmName("agccekjvalsktrpm")
    public suspend fun networkServiceDesignGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkServiceDesignGroupName = mapped
    }

    /**
     * @param value The name of the network service design version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     */
    @JvmName("ybtnhqjkielcvyts")
    public suspend fun networkServiceDesignVersionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkServiceDesignVersionName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("gjmccureiourhupp")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqcgsskutyuvhpkj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkServiceDesignVersionPlainArgs =
        GetNetworkServiceDesignVersionPlainArgs(
            networkServiceDesignGroupName = networkServiceDesignGroupName ?: throw
                PulumiNullFieldException("networkServiceDesignGroupName"),
            networkServiceDesignVersionName = networkServiceDesignVersionName ?: throw
                PulumiNullFieldException("networkServiceDesignVersionName"),
            publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
