@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetSiteNetworkServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteNetworkServiceName The name of the site network service.
 */
public data class GetSiteNetworkServicePlainArgs(
    public val resourceGroupName: String,
    public val siteNetworkServiceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetSiteNetworkServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetSiteNetworkServicePlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetSiteNetworkServicePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteNetworkServiceName(siteNetworkServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSiteNetworkServicePlainArgs].
 */
@PulumiTagMarker
public class GetSiteNetworkServicePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var siteNetworkServiceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("erahymimrkmfwgek")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the site network service.
     */
    @JvmName("wwgdhjqrafcqquxy")
    public suspend fun siteNetworkServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteNetworkServiceName = mapped
    }

    internal fun build(): GetSiteNetworkServicePlainArgs = GetSiteNetworkServicePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteNetworkServiceName = siteNetworkServiceName ?: throw
            PulumiNullFieldException("siteNetworkServiceName"),
    )
}
