@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkuPreviewPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property previewSubscription Preview subscription ID.
 * @property skuName The name of the vendor sku.
 * @property vendorName The name of the vendor.
 */
public data class GetVendorSkuPreviewPlainArgs(
    public val previewSubscription: String,
    public val skuName: String,
    public val vendorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkuPreviewPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkuPreviewPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkuPreviewPlainArgs.builder()
            .previewSubscription(previewSubscription.let({ args0 -> args0 }))
            .skuName(skuName.let({ args0 -> args0 }))
            .vendorName(vendorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVendorSkuPreviewPlainArgs].
 */
@PulumiTagMarker
public class GetVendorSkuPreviewPlainArgsBuilder internal constructor() {
    private var previewSubscription: String? = null

    private var skuName: String? = null

    private var vendorName: String? = null

    /**
     * @param value Preview subscription ID.
     */
    @JvmName("bernbcriaerijopr")
    public suspend fun previewSubscription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.previewSubscription = mapped
    }

    /**
     * @param value The name of the vendor sku.
     */
    @JvmName("ceesrbppkqpqjxod")
    public suspend fun skuName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.skuName = mapped
    }

    /**
     * @param value The name of the vendor.
     */
    @JvmName("tigfbrjbkprrqqcs")
    public suspend fun vendorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vendorName = mapped
    }

    internal fun build(): GetVendorSkuPreviewPlainArgs = GetVendorSkuPreviewPlainArgs(
        previewSubscription = previewSubscription ?: throw PulumiNullFieldException("previewSubscription"),
        skuName = skuName ?: throw PulumiNullFieldException("skuName"),
        vendorName = vendorName ?: throw PulumiNullFieldException("vendorName"),
    )
}
