@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property skuName The name of the sku.
 * @property vendorName The name of the vendor.
 */
public data class GetVendorSkusPlainArgs(
    public val skuName: String,
    public val vendorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkusPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkusPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetVendorSkusPlainArgs.builder()
            .skuName(skuName.let({ args0 -> args0 }))
            .vendorName(vendorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVendorSkusPlainArgs].
 */
@PulumiTagMarker
public class GetVendorSkusPlainArgsBuilder internal constructor() {
    private var skuName: String? = null

    private var vendorName: String? = null

    /**
     * @param value The name of the sku.
     */
    @JvmName("qufvxxccvbhhbnqb")
    public suspend fun skuName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.skuName = mapped
    }

    /**
     * @param value The name of the vendor.
     */
    @JvmName("tlnmtnkswgvxntig")
    public suspend fun vendorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vendorName = mapped
    }

    internal fun build(): GetVendorSkusPlainArgs = GetVendorSkusPlainArgs(
        skuName = skuName ?: throw PulumiNullFieldException("skuName"),
        vendorName = vendorName ?: throw PulumiNullFieldException("vendorName"),
    )
}
