@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.HelmArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Helm artifact profile.
 * @property helmPackageName Helm package name.
 * @property helmPackageVersionRange Helm package version range.
 * @property imagePullSecretsValuesPaths The image pull secrets values path list.
 * @property registryValuesPaths The registry values path list.
 */
public data class HelmArtifactProfileArgs(
    public val helmPackageName: Output<String>? = null,
    public val helmPackageVersionRange: Output<String>? = null,
    public val imagePullSecretsValuesPaths: Output<List<String>>? = null,
    public val registryValuesPaths: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.HelmArtifactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.HelmArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.HelmArtifactProfileArgs.builder()
            .helmPackageName(helmPackageName?.applyValue({ args0 -> args0 }))
            .helmPackageVersionRange(helmPackageVersionRange?.applyValue({ args0 -> args0 }))
            .imagePullSecretsValuesPaths(
                imagePullSecretsValuesPaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .registryValuesPaths(
                registryValuesPaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [HelmArtifactProfileArgs].
 */
@PulumiTagMarker
public class HelmArtifactProfileArgsBuilder internal constructor() {
    private var helmPackageName: Output<String>? = null

    private var helmPackageVersionRange: Output<String>? = null

    private var imagePullSecretsValuesPaths: Output<List<String>>? = null

    private var registryValuesPaths: Output<List<String>>? = null

    /**
     * @param value Helm package name.
     */
    @JvmName("hajgthpefwyvnlij")
    public suspend fun helmPackageName(`value`: Output<String>) {
        this.helmPackageName = value
    }

    /**
     * @param value Helm package version range.
     */
    @JvmName("ukkgxweenreoaden")
    public suspend fun helmPackageVersionRange(`value`: Output<String>) {
        this.helmPackageVersionRange = value
    }

    /**
     * @param value The image pull secrets values path list.
     */
    @JvmName("cfsaxxmmxsibtcvi")
    public suspend fun imagePullSecretsValuesPaths(`value`: Output<List<String>>) {
        this.imagePullSecretsValuesPaths = value
    }

    @JvmName("xjswwhmpvgvijvut")
    public suspend fun imagePullSecretsValuesPaths(vararg values: Output<String>) {
        this.imagePullSecretsValuesPaths = Output.all(values.asList())
    }

    /**
     * @param values The image pull secrets values path list.
     */
    @JvmName("fasvnqnjcadeoaxj")
    public suspend fun imagePullSecretsValuesPaths(values: List<Output<String>>) {
        this.imagePullSecretsValuesPaths = Output.all(values)
    }

    /**
     * @param value The registry values path list.
     */
    @JvmName("hphjmylrfliidfbm")
    public suspend fun registryValuesPaths(`value`: Output<List<String>>) {
        this.registryValuesPaths = value
    }

    @JvmName("vgmyfjjjtclobvhd")
    public suspend fun registryValuesPaths(vararg values: Output<String>) {
        this.registryValuesPaths = Output.all(values.asList())
    }

    /**
     * @param values The registry values path list.
     */
    @JvmName("cccdbdvwlvlldqwc")
    public suspend fun registryValuesPaths(values: List<Output<String>>) {
        this.registryValuesPaths = Output.all(values)
    }

    /**
     * @param value Helm package name.
     */
    @JvmName("uphixluxwdstosxd")
    public suspend fun helmPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmPackageName = mapped
    }

    /**
     * @param value Helm package version range.
     */
    @JvmName("xvclhlqmbmyaxodi")
    public suspend fun helmPackageVersionRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmPackageVersionRange = mapped
    }

    /**
     * @param value The image pull secrets values path list.
     */
    @JvmName("hnixleraqffebxkn")
    public suspend fun imagePullSecretsValuesPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullSecretsValuesPaths = mapped
    }

    /**
     * @param values The image pull secrets values path list.
     */
    @JvmName("lymqyufwwacfhvqf")
    public suspend fun imagePullSecretsValuesPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imagePullSecretsValuesPaths = mapped
    }

    /**
     * @param value The registry values path list.
     */
    @JvmName("qiqthghevtakrjsx")
    public suspend fun registryValuesPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryValuesPaths = mapped
    }

    /**
     * @param values The registry values path list.
     */
    @JvmName("edojgwvcyxjkjxwt")
    public suspend fun registryValuesPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registryValuesPaths = mapped
    }

    internal fun build(): HelmArtifactProfileArgs = HelmArtifactProfileArgs(
        helmPackageName = helmPackageName,
        helmPackageVersionRange = helmPackageVersionRange,
        imagePullSecretsValuesPaths = imagePullSecretsValuesPaths,
        registryValuesPaths = registryValuesPaths,
    )
}
