@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.HelmInstallOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The helm deployment install options
 * @property atomic The helm deployment atomic options
 * @property timeout The helm deployment timeout options
 * @property wait The helm deployment wait options
 */
public data class HelmInstallOptionsArgs(
    public val atomic: Output<String>? = null,
    public val timeout: Output<String>? = null,
    public val wait: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.HelmInstallOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.HelmInstallOptionsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.HelmInstallOptionsArgs.builder()
            .atomic(atomic?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .wait_(wait?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HelmInstallOptionsArgs].
 */
@PulumiTagMarker
public class HelmInstallOptionsArgsBuilder internal constructor() {
    private var atomic: Output<String>? = null

    private var timeout: Output<String>? = null

    private var wait: Output<String>? = null

    /**
     * @param value The helm deployment atomic options
     */
    @JvmName("rkmpsfdetnewuyts")
    public suspend fun atomic(`value`: Output<String>) {
        this.atomic = value
    }

    /**
     * @param value The helm deployment timeout options
     */
    @JvmName("iscksmhaewjivbbt")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value The helm deployment wait options
     */
    @JvmName("uxwxdorlsqknchxe")
    public suspend fun wait(`value`: Output<String>) {
        this.wait = value
    }

    /**
     * @param value The helm deployment atomic options
     */
    @JvmName("ehtpbeuxsdumfqpm")
    public suspend fun atomic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.atomic = mapped
    }

    /**
     * @param value The helm deployment timeout options
     */
    @JvmName("pdikntycjpsqmkjx")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The helm deployment wait options
     */
    @JvmName("eaqxdwfpaygihjsd")
    public suspend fun wait(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wait = mapped
    }

    internal fun build(): HelmInstallOptionsArgs = HelmInstallOptionsArgs(
        atomic = atomic,
        timeout = timeout,
        wait = wait,
    )
}
