@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The helm deployment options
 * @property installOptions The helm deployment install options
 * @property upgradeOptions The helm deployment upgrade options
 */
public data class HelmMappingRuleProfileOptionsArgs(
    public val installOptions: Output<HelmInstallOptionsArgs>? = null,
    public val upgradeOptions: Output<HelmUpgradeOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileOptionsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileOptionsArgs.builder()
            .installOptions(installOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .upgradeOptions(
                upgradeOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HelmMappingRuleProfileOptionsArgs].
 */
@PulumiTagMarker
public class HelmMappingRuleProfileOptionsArgsBuilder internal constructor() {
    private var installOptions: Output<HelmInstallOptionsArgs>? = null

    private var upgradeOptions: Output<HelmUpgradeOptionsArgs>? = null

    /**
     * @param value The helm deployment install options
     */
    @JvmName("yvtbwbjiwgfwqelq")
    public suspend fun installOptions(`value`: Output<HelmInstallOptionsArgs>) {
        this.installOptions = value
    }

    /**
     * @param value The helm deployment upgrade options
     */
    @JvmName("fuvgieteplulffta")
    public suspend fun upgradeOptions(`value`: Output<HelmUpgradeOptionsArgs>) {
        this.upgradeOptions = value
    }

    /**
     * @param value The helm deployment install options
     */
    @JvmName("melvfhyaxltpfqvn")
    public suspend fun installOptions(`value`: HelmInstallOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installOptions = mapped
    }

    /**
     * @param argument The helm deployment install options
     */
    @JvmName("pgumyfjuciojqikn")
    public suspend fun installOptions(argument: suspend HelmInstallOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = HelmInstallOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.installOptions = mapped
    }

    /**
     * @param value The helm deployment upgrade options
     */
    @JvmName("bafsbdyosnlxscya")
    public suspend fun upgradeOptions(`value`: HelmUpgradeOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeOptions = mapped
    }

    /**
     * @param argument The helm deployment upgrade options
     */
    @JvmName("sughjrslpentowbf")
    public suspend fun upgradeOptions(argument: suspend HelmUpgradeOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = HelmUpgradeOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradeOptions = mapped
    }

    internal fun build(): HelmMappingRuleProfileOptionsArgs = HelmMappingRuleProfileOptionsArgs(
        installOptions = installOptions,
        upgradeOptions = upgradeOptions,
    )
}
