@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ImageArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image artifact profile.
 * @property imageName Image name.
 * @property imageVersion Image version.
 */
public data class ImageArtifactProfileArgs(
    public val imageName: Output<String>? = null,
    public val imageVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ImageArtifactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ImageArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ImageArtifactProfileArgs.builder()
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .imageVersion(imageVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageArtifactProfileArgs].
 */
@PulumiTagMarker
public class ImageArtifactProfileArgsBuilder internal constructor() {
    private var imageName: Output<String>? = null

    private var imageVersion: Output<String>? = null

    /**
     * @param value Image name.
     */
    @JvmName("lxqlrlqapvyjqvje")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Image version.
     */
    @JvmName("inivvqqbnxxtpurk")
    public suspend fun imageVersion(`value`: Output<String>) {
        this.imageVersion = value
    }

    /**
     * @param value Image name.
     */
    @JvmName("gmtevbfjnjfebwwu")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Image version.
     */
    @JvmName("wobknoqwxdgkxjgy")
    public suspend fun imageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageVersion = mapped
    }

    internal fun build(): ImageArtifactProfileArgs = ImageArtifactProfileArgs(
        imageName = imageName,
        imageVersion = imageVersion,
    )
}
