@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ManagedResourceGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed resource group configuration.
 * @property location Managed resource group location.
 * @property name Managed resource group name.
 */
public data class ManagedResourceGroupConfigurationArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ManagedResourceGroupConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ManagedResourceGroupConfigurationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ManagedResourceGroupConfigurationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedResourceGroupConfigurationArgs].
 */
@PulumiTagMarker
public class ManagedResourceGroupConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Managed resource group location.
     */
    @JvmName("kiihbjaeicgsdgli")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Managed resource group name.
     */
    @JvmName("tgdkkahurqksurex")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Managed resource group location.
     */
    @JvmName("sntmbnuelqrjjyfo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Managed resource group name.
     */
    @JvmName("eytqlemomvhiabts")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagedResourceGroupConfigurationArgs =
        ManagedResourceGroupConfigurationArgs(
            location = location,
            name = name,
        )
}
