@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ManifestArtifactFormatArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ArtifactType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manifest artifact properties.
 * @property artifactName The artifact name
 * @property artifactType The artifact type.
 * @property artifactVersion The artifact version.
 */
public data class ManifestArtifactFormatArgs(
    public val artifactName: Output<String>? = null,
    public val artifactType: Output<Either<String, ArtifactType>>? = null,
    public val artifactVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ManifestArtifactFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ManifestArtifactFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ManifestArtifactFormatArgs.builder()
            .artifactName(artifactName?.applyValue({ args0 -> args0 }))
            .artifactType(
                artifactType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .artifactVersion(artifactVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManifestArtifactFormatArgs].
 */
@PulumiTagMarker
public class ManifestArtifactFormatArgsBuilder internal constructor() {
    private var artifactName: Output<String>? = null

    private var artifactType: Output<Either<String, ArtifactType>>? = null

    private var artifactVersion: Output<String>? = null

    /**
     * @param value The artifact name
     */
    @JvmName("gtyfpjpfsrevbiva")
    public suspend fun artifactName(`value`: Output<String>) {
        this.artifactName = value
    }

    /**
     * @param value The artifact type.
     */
    @JvmName("jtxplmkaospcqxqn")
    public suspend fun artifactType(`value`: Output<Either<String, ArtifactType>>) {
        this.artifactType = value
    }

    /**
     * @param value The artifact version.
     */
    @JvmName("gxxwuwfwqgxhkbdb")
    public suspend fun artifactVersion(`value`: Output<String>) {
        this.artifactVersion = value
    }

    /**
     * @param value The artifact name
     */
    @JvmName("nttpkmxywtjvkoio")
    public suspend fun artifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactName = mapped
    }

    /**
     * @param value The artifact type.
     */
    @JvmName("ilkpeuebprcryhia")
    public suspend fun artifactType(`value`: Either<String, ArtifactType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value The artifact type.
     */
    @JvmName("fwduxeiidoqamuba")
    public fun artifactType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ArtifactType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value The artifact type.
     */
    @JvmName("dnhuwtuuhturowqh")
    public fun artifactType(`value`: ArtifactType) {
        val toBeMapped = Either.ofRight<String, ArtifactType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value The artifact version.
     */
    @JvmName("qrjnurqxneowcjsk")
    public suspend fun artifactVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactVersion = mapped
    }

    internal fun build(): ManifestArtifactFormatArgs = ManifestArtifactFormatArgs(
        artifactName = artifactName,
        artifactType = artifactType,
        artifactVersion = artifactVersion,
    )
}
