@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionGroupPropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network function definition group properties.
 * @property description The network function definition group description.
 */
public data class NetworkFunctionDefinitionGroupPropertiesFormatArgs(
    public val description: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionGroupPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionGroupPropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionDefinitionGroupPropertiesFormatArgs.builder()
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkFunctionDefinitionGroupPropertiesFormatArgs].
 */
@PulumiTagMarker
public class NetworkFunctionDefinitionGroupPropertiesFormatArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    /**
     * @param value The network function definition group description.
     */
    @JvmName("vwvixoykmydfpnum")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The network function definition group description.
     */
    @JvmName("obyfffouknwkewte")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): NetworkFunctionDefinitionGroupPropertiesFormatArgs =
        NetworkFunctionDefinitionGroupPropertiesFormatArgs(
            description = description,
        )
}
