@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionRoleConfigurationArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.NetworkFunctionRoleConfigurationType
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.VirtualMachineSizeTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network function role configuration.
 * @property customProfile Specifies the custom settings for the virtual machine.
 * @property networkInterfaces The network interface configurations.
 * @property osProfile Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
 * @property roleName The name of the network function role.
 * @property roleType Role type.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property userDataParameters The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
 * @property userDataTemplate The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
 * @property virtualMachineSize The size of the virtual machine.
 */
public data class NetworkFunctionRoleConfigurationArgs(
    public val customProfile: Output<CustomProfileArgs>? = null,
    public val networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null,
    public val osProfile: Output<OsProfileArgs>? = null,
    public val roleName: Output<String>? = null,
    public val roleType: Output<Either<String, NetworkFunctionRoleConfigurationType>>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val userDataParameters: Output<Any>? = null,
    public val userDataTemplate: Output<Any>? = null,
    public val virtualMachineSize: Output<Either<String, VirtualMachineSizeTypes>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionRoleConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionRoleConfigurationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionRoleConfigurationArgs.builder()
            .customProfile(customProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .roleType(
                roleType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userDataParameters(userDataParameters?.applyValue({ args0 -> args0 }))
            .userDataTemplate(userDataTemplate?.applyValue({ args0 -> args0 }))
            .virtualMachineSize(
                virtualMachineSize?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [NetworkFunctionRoleConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkFunctionRoleConfigurationArgsBuilder internal constructor() {
    private var customProfile: Output<CustomProfileArgs>? = null

    private var networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null

    private var osProfile: Output<OsProfileArgs>? = null

    private var roleName: Output<String>? = null

    private var roleType: Output<Either<String, NetworkFunctionRoleConfigurationType>>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var userDataParameters: Output<Any>? = null

    private var userDataTemplate: Output<Any>? = null

    private var virtualMachineSize: Output<Either<String, VirtualMachineSizeTypes>>? = null

    /**
     * @param value Specifies the custom settings for the virtual machine.
     */
    @JvmName("foupvvsanellmkys")
    public suspend fun customProfile(`value`: Output<CustomProfileArgs>) {
        this.customProfile = value
    }

    /**
     * @param value The network interface configurations.
     */
    @JvmName("lusotamqmnomdmwv")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("ddmgeppwopbbvsct")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values The network interface configurations.
     */
    @JvmName("djdiwwxtabhxskjt")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
     */
    @JvmName("pippegybjwruuhmh")
    public suspend fun osProfile(`value`: Output<OsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The name of the network function role.
     */
    @JvmName("usdxjmxdpuclmwyg")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value Role type.
     */
    @JvmName("jbveiaoyamtlidke")
    public suspend
    fun roleType(`value`: Output<Either<String, NetworkFunctionRoleConfigurationType>>) {
        this.roleType = value
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("wogbhmqcmetmmott")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
     */
    @JvmName("imjstlogvuklntsx")
    public suspend fun userDataParameters(`value`: Output<Any>) {
        this.userDataParameters = value
    }

    /**
     * @param value The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
     */
    @JvmName("doortdrmqodkwbyl")
    public suspend fun userDataTemplate(`value`: Output<Any>) {
        this.userDataTemplate = value
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("hbiwlrkmhfaywnpv")
    public suspend fun virtualMachineSize(`value`: Output<Either<String, VirtualMachineSizeTypes>>) {
        this.virtualMachineSize = value
    }

    /**
     * @param value Specifies the custom settings for the virtual machine.
     */
    @JvmName("ctcjneklvwcpewwy")
    public suspend fun customProfile(`value`: CustomProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProfile = mapped
    }

    /**
     * @param argument Specifies the custom settings for the virtual machine.
     */
    @JvmName("xovxyycgpfcbwnlg")
    public suspend fun customProfile(argument: suspend CustomProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CustomProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customProfile = mapped
    }

    /**
     * @param value The network interface configurations.
     */
    @JvmName("vmrdupnlkhuvfyvs")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The network interface configurations.
     */
    @JvmName("acwqiqfhhflimynv")
    public suspend
    fun networkInterfaces(argument: List<suspend NetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The network interface configurations.
     */
    @JvmName("vguiiqheunjduqfu")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend NetworkInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The network interface configurations.
     */
    @JvmName("vpsjhpqyhkvoqdwr")
    public suspend fun networkInterfaces(argument: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkInterfaceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values The network interface configurations.
     */
    @JvmName("lxcdlunlubkpuivj")
    public suspend fun networkInterfaces(vararg values: NetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
     */
    @JvmName("dypmqdfcpmnsbmjm")
    public suspend fun osProfile(`value`: OsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
     */
    @JvmName("hohvwjmwdgmloqpg")
    public suspend fun osProfile(argument: suspend OsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The name of the network function role.
     */
    @JvmName("fdxjakirelminrhh")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value Role type.
     */
    @JvmName("sqbhchsdbtvofkrt")
    public suspend fun roleType(`value`: Either<String, NetworkFunctionRoleConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    /**
     * @param value Role type.
     */
    @JvmName("lhhrasohksasidoi")
    public fun roleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkFunctionRoleConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    /**
     * @param value Role type.
     */
    @JvmName("ihyfnwpmgnnqiqmk")
    public fun roleType(`value`: NetworkFunctionRoleConfigurationType) {
        val toBeMapped = Either.ofRight<String, NetworkFunctionRoleConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("qsqpiyyfsnsmlepc")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("fvpvwyaeoegrlsgw")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
     */
    @JvmName("ifgcajglifrtiliy")
    public suspend fun userDataParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataParameters = mapped
    }

    /**
     * @param value The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
     */
    @JvmName("hsnaehoyvcmkxpjf")
    public suspend fun userDataTemplate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataTemplate = mapped
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("drsdkyceswhmhjtt")
    public suspend fun virtualMachineSize(`value`: Either<String, VirtualMachineSizeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineSize = mapped
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("utiivjqhauufyfun")
    public fun virtualMachineSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineSizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineSize = mapped
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("icgkdkjclxdoscvb")
    public fun virtualMachineSize(`value`: VirtualMachineSizeTypes) {
        val toBeMapped = Either.ofRight<String, VirtualMachineSizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineSize = mapped
    }

    internal fun build(): NetworkFunctionRoleConfigurationArgs = NetworkFunctionRoleConfigurationArgs(
        customProfile = customProfile,
        networkInterfaces = networkInterfaces,
        osProfile = osProfile,
        roleName = roleName,
        roleType = roleType,
        storageProfile = storageProfile,
        userDataParameters = userDataParameters,
        userDataTemplate = userDataTemplate,
        virtualMachineSize = virtualMachineSize,
    )
}
