@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignGroupPropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * network service design group properties.
 * @property description The network service design group description.
 */
public data class NetworkServiceDesignGroupPropertiesFormatArgs(
    public val description: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignGroupPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignGroupPropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignGroupPropertiesFormatArgs.builder()
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkServiceDesignGroupPropertiesFormatArgs].
 */
@PulumiTagMarker
public class NetworkServiceDesignGroupPropertiesFormatArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    /**
     * @param value The network service design group description.
     */
    @JvmName("xthovnrdqawkptoo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The network service design group description.
     */
    @JvmName("hnycyursxesgdywj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): NetworkServiceDesignGroupPropertiesFormatArgs =
        NetworkServiceDesignGroupPropertiesFormatArgs(
            description = description,
        )
}
