@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.OsDiskArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.OperatingSystemTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
 * @property diskSizeGB Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
 * @property name The VHD name.
 * @property osType The OS type.
 * @property vhd The virtual hard disk.
 */
public data class OsDiskArgs(
    public val diskSizeGB: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val osType: Output<Either<String, OperatingSystemTypes>>? = null,
    public val vhd: Output<VirtualHardDiskArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.OsDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.OsDiskArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.OsDiskArgs.builder()
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vhd(vhd?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OsDiskArgs].
 */
@PulumiTagMarker
public class OsDiskArgsBuilder internal constructor() {
    private var diskSizeGB: Output<Int>? = null

    private var name: Output<String>? = null

    private var osType: Output<Either<String, OperatingSystemTypes>>? = null

    private var vhd: Output<VirtualHardDiskArgs>? = null

    /**
     * @param value Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
     */
    @JvmName("slqhyebwoqnbvweo")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value The VHD name.
     */
    @JvmName("fcygrynulshwfcpo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The OS type.
     */
    @JvmName("ktycybharxjmynnx")
    public suspend fun osType(`value`: Output<Either<String, OperatingSystemTypes>>) {
        this.osType = value
    }

    /**
     * @param value The virtual hard disk.
     */
    @JvmName("ihsuynlwveseabrh")
    public suspend fun vhd(`value`: Output<VirtualHardDiskArgs>) {
        this.vhd = value
    }

    /**
     * @param value Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
     */
    @JvmName("ueyciyieddfducbw")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value The VHD name.
     */
    @JvmName("hmggpacqbuvwquvq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The OS type.
     */
    @JvmName("ykyyqatxsjbhcftu")
    public suspend fun osType(`value`: Either<String, OperatingSystemTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The OS type.
     */
    @JvmName("oikmkjnuywljvipr")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatingSystemTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The OS type.
     */
    @JvmName("fbhsarqftwkovbly")
    public fun osType(`value`: OperatingSystemTypes) {
        val toBeMapped = Either.ofRight<String, OperatingSystemTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The virtual hard disk.
     */
    @JvmName("sjmrkbansmpvaaxb")
    public suspend fun vhd(`value`: VirtualHardDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhd = mapped
    }

    /**
     * @param argument The virtual hard disk.
     */
    @JvmName("gopnhitokpmqmftj")
    public suspend fun vhd(argument: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHardDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vhd = mapped
    }

    internal fun build(): OsDiskArgs = OsDiskArgs(
        diskSizeGB = diskSizeGB,
        name = name,
        osType = osType,
        vhd = vhd,
    )
}
