@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure Arc kubernetes network function template.
 * @property networkFunctionApplications Network function applications.
 * @property nfviType The network function type.
 * Expected value is 'AzureArcKubernetes'.
 */
public data class AzureArcKubernetesNetworkFunctionTemplateResponse(
    public val networkFunctionApplications: List<AzureArcKubernetesHelmApplicationResponse>? = null,
    public val nfviType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureArcKubernetesNetworkFunctionTemplateResponse):
            AzureArcKubernetesNetworkFunctionTemplateResponse =
            AzureArcKubernetesNetworkFunctionTemplateResponse(
                networkFunctionApplications = javaType.networkFunctionApplications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureArcKubernetesHelmApplicationResponse.Companion.toKotlin(args0)
                    })
                }),
                nfviType = javaType.nfviType(),
            )
    }
}
