@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure template deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property templateMappingRuleProfile The template mapping rule profile.
 */
public data class AzureCoreArmTemplateDeployMappingRuleProfileResponse(
    public val applicationEnablement: String? = null,
    public val templateMappingRuleProfile: ArmTemplateMappingRuleProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreArmTemplateDeployMappingRuleProfileResponse):
            AzureCoreArmTemplateDeployMappingRuleProfileResponse =
            AzureCoreArmTemplateDeployMappingRuleProfileResponse(
                applicationEnablement = javaType.applicationEnablement().map({ args0 -> args0 }).orElse(null),
                templateMappingRuleProfile = javaType.templateMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArmTemplateMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
