@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure virtual network function template.
 * @property networkFunctionApplications Network function applications.
 * @property nfviType The network function type.
 * Expected value is 'AzureCore'.
 */
public data class AzureCoreNetworkFunctionTemplateResponse(
    public val networkFunctionApplications:
    List<Either<AzureCoreNetworkFunctionArmTemplateApplicationResponse, AzureCoreNetworkFunctionVhdApplicationResponse>>? =
        null,
    public val nfviType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreNetworkFunctionTemplateResponse):
            AzureCoreNetworkFunctionTemplateResponse = AzureCoreNetworkFunctionTemplateResponse(
            networkFunctionApplications = javaType.networkFunctionApplications().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureCoreNetworkFunctionArmTemplateApplicationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureCoreNetworkFunctionVhdApplicationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            nfviType = javaType.nfviType(),
        )
    }
}
