@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * The ConfigurationValue with secrets.
 * @property configurationGroupSchemaName The configuration group schema name.
 * @property configurationGroupSchemaOfferingLocation The location of the configuration group schema offering.
 * @property configurationGroupSchemaResourceReference The configuration group schema resource reference.
 * @property configurationType The secret type which indicates if secret or not.
 * Expected value is 'Secret'.
 * @property provisioningState The provisioning state of the site resource.
 * @property publisherName The publisher name for the configuration group schema.
 * @property publisherScope The scope of the publisher.
 */
public data class ConfigurationValueWithSecretsResponse(
    public val configurationGroupSchemaName: String,
    public val configurationGroupSchemaOfferingLocation: String,
    public val configurationGroupSchemaResourceReference:
    Either<OpenDeploymentResourceReferenceResponse, SecretDeploymentResourceReferenceResponse>? =
        null,
    public val configurationType: String,
    public val provisioningState: String,
    public val publisherName: String,
    public val publisherScope: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ConfigurationValueWithSecretsResponse):
            ConfigurationValueWithSecretsResponse = ConfigurationValueWithSecretsResponse(
            configurationGroupSchemaName = javaType.configurationGroupSchemaName(),
            configurationGroupSchemaOfferingLocation = javaType.configurationGroupSchemaOfferingLocation(),
            configurationGroupSchemaResourceReference = javaType.configurationGroupSchemaResourceReference().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.OpenDeploymentResourceReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SecretDeploymentResourceReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            configurationType = javaType.configurationType(),
            provisioningState = javaType.provisioningState(),
            publisherName = javaType.publisherName(),
            publisherScope = javaType.publisherScope(),
        )
    }
}
