@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Helm mapping rule profile
 * @property helmPackageVersion Helm package version.
 * @property options The helm deployment options
 * @property releaseName Helm release name.
 * @property releaseNamespace Helm release namespace.
 * @property values Helm release values.
 */
public data class HelmMappingRuleProfileResponse(
    public val helmPackageVersion: String? = null,
    public val options: HelmMappingRuleProfileResponseOptions? = null,
    public val releaseName: String? = null,
    public val releaseNamespace: String? = null,
    public val values: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.HelmMappingRuleProfileResponse):
            HelmMappingRuleProfileResponse = HelmMappingRuleProfileResponse(
            helmPackageVersion = javaType.helmPackageVersion().map({ args0 -> args0 }).orElse(null),
            options = javaType.options().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.HelmMappingRuleProfileResponseOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            releaseName = javaType.releaseName().map({ args0 -> args0 }).orElse(null),
            releaseNamespace = javaType.releaseNamespace().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }).orElse(null),
        )
    }
}
