@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.EncryptionKeyDetailsArgs.builder
import com.pulumi.azurenative.importexport.kotlin.enums.EncryptionKekType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the encryption key properties
 * @property kekType The type of kek encryption key
 * @property kekUrl Specifies the url for kek encryption key.
 * @property kekVaultResourceID Specifies the keyvault resource id for kek encryption key.
 */
public data class EncryptionKeyDetailsArgs(
    public val kekType: Output<Either<String, EncryptionKekType>>? = null,
    public val kekUrl: Output<String>? = null,
    public val kekVaultResourceID: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.EncryptionKeyDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.EncryptionKeyDetailsArgs =
        com.pulumi.azurenative.importexport.inputs.EncryptionKeyDetailsArgs.builder()
            .kekType(
                kekType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kekUrl(kekUrl?.applyValue({ args0 -> args0 }))
            .kekVaultResourceID(kekVaultResourceID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionKeyDetailsArgs].
 */
@PulumiTagMarker
public class EncryptionKeyDetailsArgsBuilder internal constructor() {
    private var kekType: Output<Either<String, EncryptionKekType>>? = null

    private var kekUrl: Output<String>? = null

    private var kekVaultResourceID: Output<String>? = null

    /**
     * @param value The type of kek encryption key
     */
    @JvmName("cgnstluxastdniff")
    public suspend fun kekType(`value`: Output<Either<String, EncryptionKekType>>) {
        this.kekType = value
    }

    /**
     * @param value Specifies the url for kek encryption key.
     */
    @JvmName("fdmbxkauuyppjvoj")
    public suspend fun kekUrl(`value`: Output<String>) {
        this.kekUrl = value
    }

    /**
     * @param value Specifies the keyvault resource id for kek encryption key.
     */
    @JvmName("lyqtfiyicaqoqetd")
    public suspend fun kekVaultResourceID(`value`: Output<String>) {
        this.kekVaultResourceID = value
    }

    /**
     * @param value The type of kek encryption key
     */
    @JvmName("sbnrvjxgpgncgtfn")
    public suspend fun kekType(`value`: Either<String, EncryptionKekType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekType = mapped
    }

    /**
     * @param value The type of kek encryption key
     */
    @JvmName("pfwijifmrlwnbjtw")
    public fun kekType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionKekType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kekType = mapped
    }

    /**
     * @param value The type of kek encryption key
     */
    @JvmName("gdshutoacufqlony")
    public fun kekType(`value`: EncryptionKekType) {
        val toBeMapped = Either.ofRight<String, EncryptionKekType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kekType = mapped
    }

    /**
     * @param value Specifies the url for kek encryption key.
     */
    @JvmName("bbxwlrjpqahccgwa")
    public suspend fun kekUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekUrl = mapped
    }

    /**
     * @param value Specifies the keyvault resource id for kek encryption key.
     */
    @JvmName("omnwdbptjkgjorir")
    public suspend fun kekVaultResourceID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekVaultResourceID = mapped
    }

    internal fun build(): EncryptionKeyDetailsArgs = EncryptionKeyDetailsArgs(
        kekType = kekType,
        kekUrl = kekUrl,
        kekVaultResourceID = kekVaultResourceID,
    )
}
