@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.GetJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobName The name of the import/export job.
 * @property resourceGroupName The resource group name uniquely identifies the resource group within the user subscription.
 */
public data class GetJobPlainArgs(
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.GetJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.GetJobPlainArgs =
        com.pulumi.azurenative.importexport.inputs.GetJobPlainArgs.builder()
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobPlainArgs].
 */
@PulumiTagMarker
public class GetJobPlainArgsBuilder internal constructor() {
    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the import/export job.
     */
    @JvmName("rdbcxrnjwsxibjdl")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The resource group name uniquely identifies the resource group within the user subscription.
     */
    @JvmName("qayslatvtwdffxkf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobPlainArgs = GetJobPlainArgs(
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
