@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the encryption key properties
 * @property kekType The type of kek encryption key
 * @property kekUrl Specifies the url for kek encryption key.
 * @property kekVaultResourceID Specifies the keyvault resource id for kek encryption key.
 */
public data class EncryptionKeyDetailsResponse(
    public val kekType: String? = null,
    public val kekUrl: String? = null,
    public val kekVaultResourceID: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.EncryptionKeyDetailsResponse):
            EncryptionKeyDetailsResponse = EncryptionKeyDetailsResponse(
            kekType = javaType.kekType().map({ args0 -> args0 }).orElse(null),
            kekUrl = javaType.kekUrl().map({ args0 -> args0 }).orElse(null),
            kekVaultResourceID = javaType.kekVaultResourceID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
