@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Contains information about the package being shipped by the customer to the Microsoft data center.
 * @property carrierName The name of the carrier that is used to ship the import or export drives.
 * @property driveCount The number of drives included in the package.
 * @property shipDate The date when the package is shipped.
 * @property trackingNumber The tracking number of the package.
 */
public data class PackageInformationResponse(
    public val carrierName: String,
    public val driveCount: Double,
    public val shipDate: String,
    public val trackingNumber: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.PackageInformationResponse):
            PackageInformationResponse = PackageInformationResponse(
            carrierName = javaType.carrierName(),
            driveCount = javaType.driveCount(),
            shipDate = javaType.shipDate(),
            trackingNumber = javaType.trackingNumber(),
        )
    }
}
