@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the return carrier and customer's account with the carrier.
 * @property carrierAccountNumber The customer's account number with the carrier.
 * @property carrierName The carrier's name.
 */
public data class ReturnShippingResponse(
    public val carrierAccountNumber: String,
    public val carrierName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.ReturnShippingResponse):
            ReturnShippingResponse = ReturnShippingResponse(
            carrierAccountNumber = javaType.carrierAccountNumber(),
            carrierName = javaType.carrierName(),
        )
    }
}
