@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ActionListResponse
import com.pulumi.azurenative.insights.kotlin.outputs.AlertRuleAllOfConditionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.ActionListResponse.Companion.toKotlin as actionListResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.AlertRuleAllOfConditionResponse.Companion.toKotlin as alertRuleAllOfConditionResponseToKotlin

/**
 * Builder for [ActivityLogAlert].
 */
@PulumiTagMarker
public class ActivityLogAlertResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActivityLogAlertArgs = ActivityLogAlertArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActivityLogAlertArgsBuilder.() -> Unit) {
        val builder = ActivityLogAlertArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ActivityLogAlert {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ActivityLogAlert(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ActivityLogAlert(builtJavaResource)
    }
}

/**
 * An Activity Log Alert rule resource.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2017-04-01, 2020-10-01.
 * ## Example Usage
 * ### Create or update an Activity Log Alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     ActionProperties =
 *                     {
 *                         { "Email.Title", "my email title" },
 *                     },
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertRule",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "Administrative",
 *                     Field = "category",
 *                 },
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "Error",
 *                     Field = "level",
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert rule.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/187f412d-1758-44d9-b052-169e2564721d",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * 			Actions: insights.ActionListResponse{
 * 				ActionGroups: insights.ActionGroupTypeArray{
 * 					&insights.ActionGroupTypeArgs{
 * 						ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * 						ActionProperties: pulumi.StringMap{
 * 							"Email.Title": pulumi.String("my email title"),
 * 						},
 * 						WebhookProperties: pulumi.StringMap{
 * 							"sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ActivityLogAlertName: pulumi.String("SampleActivityLogAlertRule"),
 * 			Condition: insights.AlertRuleAllOfConditionResponse{
 * 				AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("Administrative"),
 * 						Field:  pulumi.String("category"),
 * 					},
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("Error"),
 * 						Field:  pulumi.String("level"),
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("Description of sample Activity Log Alert rule."),
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("actionProperties", Map.of("Email.Title", "my email title")),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertRule")
 *             .condition(Map.of("allOf",
 *                 Map.ofEntries(
 *                     Map.entry("equals", "Administrative"),
 *                     Map.entry("field", "category")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("equals", "Error"),
 *                     Map.entry("field", "level")
 *                 )))
 *             .description("Description of sample Activity Log Alert rule.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopes("/subscriptions/187f412d-1758-44d9-b052-169e2564721d")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an Activity Log Alert rule for tenant level events
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     ActionProperties =
 *                     {
 *                         { "Email.Title", "my email title" },
 *                     },
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertSHRuleOnTenantLevel",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "ServiceHealth",
 *                     Field = "category",
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert service health rule on tenant level events.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Tags = null,
 *         TenantScope = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * 			Actions: insights.ActionListResponse{
 * 				ActionGroups: insights.ActionGroupTypeArray{
 * 					&insights.ActionGroupTypeArgs{
 * 						ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * 						ActionProperties: pulumi.StringMap{
 * 							"Email.Title": pulumi.String("my email title"),
 * 						},
 * 						WebhookProperties: pulumi.StringMap{
 * 							"sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ActivityLogAlertName: pulumi.String("SampleActivityLogAlertSHRuleOnTenantLevel"),
 * 			Condition: insights.AlertRuleAllOfConditionResponse{
 * 				AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("ServiceHealth"),
 * 						Field:  pulumi.String("category"),
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("Description of sample Activity Log Alert service health rule on tenant level events."),
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Tags:              nil,
 * 			TenantScope:       pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("actionProperties", Map.of("Email.Title", "my email title")),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertSHRuleOnTenantLevel")
 *             .condition(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("equals", "ServiceHealth"),
 *                 Map.entry("field", "category")
 *             )))
 *             .description("Description of sample Activity Log Alert service health rule on tenant level events.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .tags()
 *             .tenantScope("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an Activity Log Alert rule with 'anyOf' condition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     ActionProperties =
 *                     {
 *                         { "Email.Title", "my email title" },
 *                     },
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertRuleWithAnyOfCondition",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "ServiceHealth",
 *                     Field = "category",
 *                 },
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     AnyOf = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.AlertRuleLeafConditionArgs
 *                         {
 *                             Equals = "Incident",
 *                             Field = "properties.incidentType",
 *                         },
 *                         new AzureNative.Insights.Inputs.AlertRuleLeafConditionArgs
 *                         {
 *                             Equals = "Maintenance",
 *                             Field = "properties.incidentType",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert rule with 'anyOf' condition.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Scopes = new[]
 *         {
 *             "subscriptions/187f412d-1758-44d9-b052-169e2564721d",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * Actions: insights.ActionListResponse{
 * ActionGroups: insights.ActionGroupTypeArray{
 * &insights.ActionGroupTypeArgs{
 * ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * ActionProperties: pulumi.StringMap{
 * "Email.Title": pulumi.String("my email title"),
 * },
 * WebhookProperties: pulumi.StringMap{
 * "sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * },
 * },
 * },
 * },
 * ActivityLogAlertName: pulumi.String("SampleActivityLogAlertRuleWithAnyOfCondition"),
 * Condition: insights.AlertRuleAllOfConditionResponse{
 * AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * &insights.AlertRuleAnyOfOrLeafConditionArgs{
 * Equals: pulumi.String("ServiceHealth"),
 * Field: pulumi.String("category"),
 * },
 * interface{}{
 * AnyOf: insights.AlertRuleLeafConditionArray{
 * &insights.AlertRuleLeafConditionArgs{
 * Equals: pulumi.String("Incident"),
 * Field: pulumi.String("properties.incidentType"),
 * },
 * &insights.AlertRuleLeafConditionArgs{
 * Equals: pulumi.String("Maintenance"),
 * Field: pulumi.String("properties.incidentType"),
 * },
 * },
 * },
 * },
 * },
 * Description: pulumi.String("Description of sample Activity Log Alert rule with 'anyOf' condition."),
 * Enabled: pulumi.Bool(true),
 * Location: pulumi.String("Global"),
 * ResourceGroupName: pulumi.String("MyResourceGroup"),
 * Scopes: pulumi.StringArray{
 * pulumi.String("subscriptions/187f412d-1758-44d9-b052-169e2564721d"),
 * },
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("actionProperties", Map.of("Email.Title", "my email title")),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertRuleWithAnyOfCondition")
 *             .condition(Map.of("allOf",
 *                 Map.ofEntries(
 *                     Map.entry("equals", "ServiceHealth"),
 *                     Map.entry("field", "category")
 *                 ),
 *                 Map.of("anyOf",
 *                     Map.ofEntries(
 *                         Map.entry("equals", "Incident"),
 *                         Map.entry("field", "properties.incidentType")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("equals", "Maintenance"),
 *                         Map.entry("field", "properties.incidentType")
 *                     ))))
 *             .description("Description of sample Activity Log Alert rule with 'anyOf' condition.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopes("subscriptions/187f412d-1758-44d9-b052-169e2564721d")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an Activity Log Alert rule with 'containsAny'
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     ActionProperties =
 *                     {
 *                         { "Email.Title", "my email title" },
 *                     },
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertRuleWithContainsAny",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "ServiceHealth",
 *                     Field = "category",
 *                 },
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     ContainsAny = new[]
 *                     {
 *                         "North Europe",
 *                         "West Europe",
 *                     },
 *                     Field = "properties.impactedServices[*].ImpactedRegions[*].RegionName",
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert rule with 'containsAny'.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Scopes = new[]
 *         {
 *             "subscriptions/187f412d-1758-44d9-b052-169e2564721d",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * 			Actions: insights.ActionListResponse{
 * 				ActionGroups: insights.ActionGroupTypeArray{
 * 					&insights.ActionGroupTypeArgs{
 * 						ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * 						ActionProperties: pulumi.StringMap{
 * 							"Email.Title": pulumi.String("my email title"),
 * 						},
 * 						WebhookProperties: pulumi.StringMap{
 * 							"sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ActivityLogAlertName: pulumi.String("SampleActivityLogAlertRuleWithContainsAny"),
 * 			Condition: insights.AlertRuleAllOfConditionResponse{
 * 				AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("ServiceHealth"),
 * 						Field:  pulumi.String("category"),
 * 					},
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						ContainsAny: pulumi.StringArray{
 * 							pulumi.String("North Europe"),
 * 							pulumi.String("West Europe"),
 * 						},
 * 						Field: pulumi.String("properties.impactedServices[*].ImpactedRegions[*].RegionName"),
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("Description of sample Activity Log Alert rule with 'containsAny'."),
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("subscriptions/187f412d-1758-44d9-b052-169e2564721d"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("actionProperties", Map.of("Email.Title", "my email title")),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertRuleWithContainsAny")
 *             .condition(Map.of("allOf",
 *                 Map.ofEntries(
 *                     Map.entry("equals", "ServiceHealth"),
 *                     Map.entry("field", "category")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("containsAny",
 *                         "North Europe",
 *                         "West Europe"),
 *                     Map.entry("field", "properties.impactedServices[*].ImpactedRegions[*].RegionName")
 *                 )))
 *             .description("Description of sample Activity Log Alert rule with 'containsAny'.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopes("subscriptions/187f412d-1758-44d9-b052-169e2564721d")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ActivityLogAlert SampleActivityLogAlertRuleWithContainsAny /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/activityLogAlerts/{activityLogAlertName}
 * ```
 */
public class ActivityLogAlert internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ActivityLogAlert,
) : KotlinCustomResource(javaResource, ActivityLogAlertMapper) {
    /**
     * The actions that will activate when the condition is met.
     */
    public val actions: Output<ActionListResponse>
        get() = javaResource.actions().applyValue({ args0 ->
            args0.let({ args0 ->
                actionListResponseToKotlin(args0)
            })
        })

    /**
     * The condition that will cause this alert to activate.
     */
    public val condition: Output<AlertRuleAllOfConditionResponse>
        get() = javaResource.condition().applyValue({ args0 ->
            args0.let({ args0 ->
                alertRuleAllOfConditionResponseToKotlin(args0)
            })
        })

    /**
     * A description of this Activity Log Alert rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
     */
    public val scopes: Output<List<String>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The tenant GUID. Must be provided for tenant-level and management group events rules.
     */
    public val tenantScope: Output<String>?
        get() = javaResource.tenantScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ActivityLogAlertMapper : ResourceMapper<ActivityLogAlert> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ActivityLogAlert::class == javaResource::class

    override fun map(javaResource: Resource): ActivityLogAlert = ActivityLogAlert(
        javaResource as
            com.pulumi.azurenative.insights.ActivityLogAlert,
    )
}

/**
 * @see [ActivityLogAlert].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActivityLogAlert].
 */
public suspend fun activityLogAlert(
    name: String,
    block: suspend ActivityLogAlertResourceBuilder.() -> Unit,
): ActivityLogAlert {
    val builder = ActivityLogAlertResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActivityLogAlert].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activityLogAlert(name: String): ActivityLogAlert {
    val builder = ActivityLogAlertResourceBuilder()
    builder.name(name)
    return builder.build()
}
