@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.RuleEmailActionResponse
import com.pulumi.azurenative.insights.kotlin.outputs.RuleWebhookActionResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [AlertRule].
 */
@PulumiTagMarker
public class AlertRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertRuleArgs = AlertRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertRuleArgsBuilder.() -> Unit) {
        val builder = AlertRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AlertRule {
        val builtJavaResource = com.pulumi.azurenative.insights.AlertRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlertRule(builtJavaResource)
    }
}

/**
 * The alert rule resource.
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Example Usage
 * ### Create or update an alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertRule = new AzureNative.Insights.AlertRule("alertRule", new()
 *     {
 *         Actions = new[] {},
 *         Condition = new AzureNative.Insights.Inputs.ThresholdRuleConditionArgs
 *         {
 *             DataSource = new AzureNative.Insights.Inputs.RuleMetricDataSourceArgs
 *             {
 *                 MetricName = "Requests",
 *                 OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource",
 *                 ResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest",
 *             },
 *             OdataType = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition",
 *             Operator = AzureNative.Insights.ConditionOperator.GreaterThan,
 *             Threshold = 3,
 *             TimeAggregation = AzureNative.Insights.TimeAggregationOperator.Total,
 *             WindowSize = "PT5M",
 *         },
 *         Description = "Pura Vida",
 *         IsEnabled = true,
 *         Location = "West US",
 *         Name = "chiricutin",
 *         ResourceGroupName = "Rac46PostSwapRG",
 *         RuleName = "chiricutin",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewAlertRule(ctx, "alertRule", &insights.AlertRuleArgs{
 * 			Actions: pulumi.Array{},
 * 			Condition: insights.ThresholdRuleCondition{
 * 				DataSource: insights.RuleMetricDataSource{
 * 					MetricName:  "Requests",
 * 					OdataType:   "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource",
 * 					ResourceUri: "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest",
 * 				},
 * 				OdataType:       "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition",
 * 				Operator:        insights.ConditionOperatorGreaterThan,
 * 				Threshold:       3,
 * 				TimeAggregation: insights.TimeAggregationOperatorTotal,
 * 				WindowSize:      "PT5M",
 * 			},
 * 			Description:       pulumi.String("Pura Vida"),
 * 			IsEnabled:         pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			Name:              pulumi.String("chiricutin"),
 * 			ResourceGroupName: pulumi.String("Rac46PostSwapRG"),
 * 			RuleName:          pulumi.String("chiricutin"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.AlertRule;
 * import com.pulumi.azurenative.insights.AlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertRule = new AlertRule("alertRule", AlertRuleArgs.builder()
 *             .actions()
 *             .condition(Map.ofEntries(
 *                 Map.entry("dataSource", Map.ofEntries(
 *                     Map.entry("metricName", "Requests"),
 *                     Map.entry("odataType", "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"),
 *                     Map.entry("resourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("threshold", 3),
 *                 Map.entry("timeAggregation", "Total"),
 *                 Map.entry("windowSize", "PT5M")
 *             ))
 *             .description("Pura Vida")
 *             .isEnabled(true)
 *             .location("West US")
 *             .name("chiricutin")
 *             .resourceGroupName("Rac46PostSwapRG")
 *             .ruleName("chiricutin")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:AlertRule chiricutin /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/alertrules/{ruleName}
 * ```
 */
public class AlertRule internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.AlertRule,
) : KotlinCustomResource(javaResource, AlertRuleMapper) {
    /**
     * action that is performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    public val action: Output<Either<RuleEmailActionResponse, RuleWebhookActionResponse>>?
        get() = javaResource.action().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleEmailActionResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleWebhookActionResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null)
        })

    /**
     * the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    public val actions: Output<List<Either<RuleEmailActionResponse, RuleWebhookActionResponse>>>?
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.insights.kotlin.outputs.RuleEmailActionResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.insights.kotlin.outputs.RuleWebhookActionResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                })
            }).orElse(null)
        })

    /**
     * the condition that results in the alert rule being activated.
     */
    public val condition: Output<Any>
        get() = javaResource.condition().applyValue({ args0 -> args0 })

    /**
     * the description of the alert rule that will be included in the alert email.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the flag that indicates whether the alert rule is enabled.
     */
    public val isEnabled: Output<Boolean>
        get() = javaResource.isEnabled().applyValue({ args0 -> args0 })

    /**
     * Last time the rule was updated in ISO8601 format.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the provisioning state.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AlertRuleMapper : ResourceMapper<AlertRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.AlertRule::class == javaResource::class

    override fun map(javaResource: Resource): AlertRule = AlertRule(
        javaResource as
            com.pulumi.azurenative.insights.AlertRule,
    )
}

/**
 * @see [AlertRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlertRule].
 */
public suspend fun alertRule(name: String, block: suspend AlertRuleResourceBuilder.() -> Unit):
    AlertRule {
    val builder = AlertRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlertRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alertRule(name: String): AlertRule {
    val builder = AlertRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
