@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResourceResponseIdentity
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResourceResponseSystemData
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseConfigurationAccess
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseFailoverConfiguration
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseLogsIngestion
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseMetadata
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseMetricsIngestion
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseNetworkAcls
import com.pulumi.azurenative.insights.kotlin.outputs.PrivateLinkScopedResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResourceResponseIdentity.Companion.toKotlin as dataCollectionEndpointResourceResponseIdentityToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResourceResponseSystemData.Companion.toKotlin as dataCollectionEndpointResourceResponseSystemDataToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseConfigurationAccess.Companion.toKotlin as dataCollectionEndpointResponseConfigurationAccessToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseFailoverConfiguration.Companion.toKotlin as dataCollectionEndpointResponseFailoverConfigurationToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseLogsIngestion.Companion.toKotlin as dataCollectionEndpointResponseLogsIngestionToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseMetadata.Companion.toKotlin as dataCollectionEndpointResponseMetadataToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseMetricsIngestion.Companion.toKotlin as dataCollectionEndpointResponseMetricsIngestionToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionEndpointResponseNetworkAcls.Companion.toKotlin as dataCollectionEndpointResponseNetworkAclsToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.PrivateLinkScopedResourceResponse.Companion.toKotlin as privateLinkScopedResourceResponseToKotlin

/**
 * Builder for [DataCollectionEndpoint].
 */
@PulumiTagMarker
public class DataCollectionEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataCollectionEndpointArgs = DataCollectionEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataCollectionEndpointArgsBuilder.() -> Unit) {
        val builder = DataCollectionEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataCollectionEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.insights.DataCollectionEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataCollectionEndpoint(builtJavaResource)
    }
}

/**
 * Definition of ARM tracked top level resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2021-09-01-preview.
 * ## Example Usage
 * ### Create or update data collection endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionEndpoint = new AzureNative.Insights.DataCollectionEndpoint("dataCollectionEndpoint", new()
 *     {
 *         DataCollectionEndpointName = "myCollectionEndpoint",
 *         Location = "eastus",
 *         NetworkAcls = new AzureNative.Insights.Inputs.DataCollectionEndpointNetworkAclsArgs
 *         {
 *             PublicNetworkAccess = "Enabled",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionEndpoint(ctx, "dataCollectionEndpoint", &insights.DataCollectionEndpointArgs{
 * 			DataCollectionEndpointName: pulumi.String("myCollectionEndpoint"),
 * 			Location:                   pulumi.String("eastus"),
 * 			NetworkAcls: &insights.DataCollectionEndpointNetworkAclsArgs{
 * 				PublicNetworkAccess: pulumi.String("Enabled"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionEndpoint;
 * import com.pulumi.azurenative.insights.DataCollectionEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionEndpoint = new DataCollectionEndpoint("dataCollectionEndpoint", DataCollectionEndpointArgs.builder()
 *             .dataCollectionEndpointName("myCollectionEndpoint")
 *             .location("eastus")
 *             .networkAcls(Map.of("publicNetworkAccess", "Enabled"))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionEndpoint myCollectionEndpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}
 * ```
 */
public class DataCollectionEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.DataCollectionEndpoint,
) : KotlinCustomResource(javaResource, DataCollectionEndpointMapper) {
    /**
     * The endpoint used by clients to access their configuration.
     */
    public val configurationAccess: Output<DataCollectionEndpointResponseConfigurationAccess>?
        get() = javaResource.configurationAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionEndpointResponseConfigurationAccessToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description of the data collection endpoint.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource entity tag (ETag).
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Failover configuration on this endpoint. This property is READ-ONLY.
     */
    public val failoverConfiguration: Output<DataCollectionEndpointResponseFailoverConfiguration>
        get() = javaResource.failoverConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionEndpointResponseFailoverConfigurationToKotlin(args0)
            })
        })

    /**
     * Managed service identity of the resource.
     */
    public val identity: Output<DataCollectionEndpointResourceResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionEndpointResourceResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
     */
    public val immutableId: Output<String>?
        get() = javaResource.immutableId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The endpoint used by clients to ingest logs.
     */
    public val logsIngestion: Output<DataCollectionEndpointResponseLogsIngestion>?
        get() = javaResource.logsIngestion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionEndpointResponseLogsIngestionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata for the resource. This property is READ-ONLY.
     */
    public val metadata: Output<DataCollectionEndpointResponseMetadata>
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionEndpointResponseMetadataToKotlin(args0)
            })
        })

    /**
     * The endpoint used by clients to ingest metrics.
     */
    public val metricsIngestion: Output<DataCollectionEndpointResponseMetricsIngestion>?
        get() = javaResource.metricsIngestion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionEndpointResponseMetricsIngestionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network access control rules for the endpoints.
     */
    public val networkAcls: Output<DataCollectionEndpointResponseNetworkAcls>?
        get() = javaResource.networkAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionEndpointResponseNetworkAclsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of Azure Monitor Private Link Scope Resources to which this data collection endpoint resource is associated. This property is READ-ONLY.
     */
    public val privateLinkScopedResources: Output<List<PrivateLinkScopedResourceResponse>>
        get() = javaResource.privateLinkScopedResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateLinkScopedResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The resource provisioning state. This property is READ-ONLY.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<DataCollectionEndpointResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionEndpointResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataCollectionEndpointMapper : ResourceMapper<DataCollectionEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.DataCollectionEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): DataCollectionEndpoint =
        DataCollectionEndpoint(javaResource as com.pulumi.azurenative.insights.DataCollectionEndpoint)
}

/**
 * @see [DataCollectionEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataCollectionEndpoint].
 */
public suspend fun dataCollectionEndpoint(
    name: String,
    block: suspend DataCollectionEndpointResourceBuilder.() -> Unit,
): DataCollectionEndpoint {
    val builder = DataCollectionEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataCollectionEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataCollectionEndpoint(name: String): DataCollectionEndpoint {
    val builder = DataCollectionEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
