@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.DiagnosticSettingArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.LogSettingsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.LogSettingsArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.MetricSettingsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.MetricSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The diagnostic setting resource.
 * Azure REST API version: 2021-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * ## Example Usage
 * ### Creates or Updates the diagnostic setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticSetting = new AzureNative.Insights.DiagnosticSetting("diagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         LogAnalyticsDestinationType = "Dedicated",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogSettingsArgs
 *             {
 *                 CategoryGroup = "allLogs",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Metrics = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricSettingsArgs
 *             {
 *                 Category = "WorkflowMetrics",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         Name = "mysetting",
 *         ResourceUri = "subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDiagnosticSetting(ctx, "diagnosticSetting", &insights.DiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			LogAnalyticsDestinationType: pulumi.String("Dedicated"),
 * 			Logs: []insights.LogSettingsArgs{
 * 				{
 * 					CategoryGroup: pulumi.String("allLogs"),
 * 					Enabled:       pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Metrics: []insights.MetricSettingsArgs{
 * 				{
 * 					Category: pulumi.String("WorkflowMetrics"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			Name:             pulumi.String("mysetting"),
 * 			ResourceUri:      pulumi.String("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6"),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:      pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DiagnosticSetting;
 * import com.pulumi.azurenative.insights.DiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticSetting = new DiagnosticSetting("diagnosticSetting", DiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logAnalyticsDestinationType("Dedicated")
 *             .logs(Map.ofEntries(
 *                 Map.entry("categoryGroup", "allLogs"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .metrics(Map.ofEntries(
 *                 Map.entry("category", "WorkflowMetrics"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .name("mysetting")
 *             .resourceUri("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or Updates the diagnostic setting for category
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticSetting = new AzureNative.Insights.DiagnosticSetting("diagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         LogAnalyticsDestinationType = "Dedicated",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogSettingsArgs
 *             {
 *                 Category = "WorkflowRuntime",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Metrics = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricSettingsArgs
 *             {
 *                 Category = "WorkflowMetrics",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         Name = "mysetting",
 *         ResourceUri = "subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDiagnosticSetting(ctx, "diagnosticSetting", &insights.DiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			LogAnalyticsDestinationType: pulumi.String("Dedicated"),
 * 			Logs: []insights.LogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("WorkflowRuntime"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Metrics: []insights.MetricSettingsArgs{
 * 				{
 * 					Category: pulumi.String("WorkflowMetrics"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			Name:             pulumi.String("mysetting"),
 * 			ResourceUri:      pulumi.String("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6"),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:      pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DiagnosticSetting;
 * import com.pulumi.azurenative.insights.DiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticSetting = new DiagnosticSetting("diagnosticSetting", DiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logAnalyticsDestinationType("Dedicated")
 *             .logs(Map.ofEntries(
 *                 Map.entry("category", "WorkflowRuntime"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .metrics(Map.ofEntries(
 *                 Map.entry("category", "WorkflowMetrics"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .name("mysetting")
 *             .resourceUri("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DiagnosticSetting mysetting /{resourceUri}/providers/Microsoft.Insights/diagnosticSettings/{name}
 * ```
 * @property eventHubAuthorizationRuleId The resource Id for the event hub authorization rule.
 * @property eventHubName The name of the event hub. If none is specified, the default event hub will be selected.
 * @property logAnalyticsDestinationType A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: <normalized service identity>_<normalized category name>. Possible values are: Dedicated and null (null is default.)
 * @property logs The list of logs settings.
 * @property marketplacePartnerId The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
 * @property metrics The list of metric settings.
 * @property name The name of the diagnostic setting.
 * @property resourceUri The identifier of the resource.
 * @property serviceBusRuleId The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
 * @property storageAccountId The resource ID of the storage account to which you would like to send Diagnostic Logs.
 * @property workspaceId The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
 */
public data class DiagnosticSettingArgs(
    public val eventHubAuthorizationRuleId: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val logAnalyticsDestinationType: Output<String>? = null,
    public val logs: Output<List<LogSettingsArgs>>? = null,
    public val marketplacePartnerId: Output<String>? = null,
    public val metrics: Output<List<MetricSettingsArgs>>? = null,
    public val name: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val serviceBusRuleId: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.DiagnosticSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.DiagnosticSettingArgs =
        com.pulumi.azurenative.insights.DiagnosticSettingArgs.builder()
            .eventHubAuthorizationRuleId(eventHubAuthorizationRuleId?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .logAnalyticsDestinationType(logAnalyticsDestinationType?.applyValue({ args0 -> args0 }))
            .logs(logs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .marketplacePartnerId(marketplacePartnerId?.applyValue({ args0 -> args0 }))
            .metrics(
                metrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .serviceBusRuleId(serviceBusRuleId?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiagnosticSettingArgs].
 */
@PulumiTagMarker
public class DiagnosticSettingArgsBuilder internal constructor() {
    private var eventHubAuthorizationRuleId: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var logAnalyticsDestinationType: Output<String>? = null

    private var logs: Output<List<LogSettingsArgs>>? = null

    private var marketplacePartnerId: Output<String>? = null

    private var metrics: Output<List<MetricSettingsArgs>>? = null

    private var name: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var serviceBusRuleId: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("jrafxpcivccgmqkr")
    public suspend fun eventHubAuthorizationRuleId(`value`: Output<String>) {
        this.eventHubAuthorizationRuleId = value
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("rmjvlrlejioqmvld")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: <normalized service identity>_<normalized category name>. Possible values are: Dedicated and null (null is default.)
     */
    @JvmName("somuaafhxtlmsdoc")
    public suspend fun logAnalyticsDestinationType(`value`: Output<String>) {
        this.logAnalyticsDestinationType = value
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("wvoodoxnjfwoauka")
    public suspend fun logs(`value`: Output<List<LogSettingsArgs>>) {
        this.logs = value
    }

    @JvmName("mtjhkolqbpugceyp")
    public suspend fun logs(vararg values: Output<LogSettingsArgs>) {
        this.logs = Output.all(values.asList())
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("mcwsxrixyejmcsun")
    public suspend fun logs(values: List<Output<LogSettingsArgs>>) {
        this.logs = Output.all(values)
    }

    /**
     * @param value The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    @JvmName("gorubcqqqfoneaoe")
    public suspend fun marketplacePartnerId(`value`: Output<String>) {
        this.marketplacePartnerId = value
    }

    /**
     * @param value The list of metric settings.
     */
    @JvmName("oaifggfbdxiwuott")
    public suspend fun metrics(`value`: Output<List<MetricSettingsArgs>>) {
        this.metrics = value
    }

    @JvmName("yedoarbcupmivjec")
    public suspend fun metrics(vararg values: Output<MetricSettingsArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values The list of metric settings.
     */
    @JvmName("hpshfffhiutjntco")
    public suspend fun metrics(values: List<Output<MetricSettingsArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("ranmbwmevwwdslmn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("hsgkssyatnpocvup")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("lpsflmpdakbildbh")
    public suspend fun serviceBusRuleId(`value`: Output<String>) {
        this.serviceBusRuleId = value
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("xdfppjqvyfawkgxv")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("gtdbhfvgcknhprhv")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("rcborglnmntwgsbm")
    public suspend fun eventHubAuthorizationRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubAuthorizationRuleId = mapped
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("rkhhryuspwcphmps")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: <normalized service identity>_<normalized category name>. Possible values are: Dedicated and null (null is default.)
     */
    @JvmName("repugvjmvbucuegn")
    public suspend fun logAnalyticsDestinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsDestinationType = mapped
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("mecyfwiximliwlog")
    public suspend fun logs(`value`: List<LogSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("camehnbbwdgpluwq")
    public suspend fun logs(argument: List<suspend LogSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LogSettingsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("gnwncxrtrlyovmqt")
    public suspend fun logs(vararg argument: suspend LogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LogSettingsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("wenbsnxknutlvutu")
    public suspend fun logs(argument: suspend LogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LogSettingsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("qqqbxeseewpmwbnf")
    public suspend fun logs(vararg values: LogSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param value The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    @JvmName("tftibitfcicmynyo")
    public suspend fun marketplacePartnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplacePartnerId = mapped
    }

    /**
     * @param value The list of metric settings.
     */
    @JvmName("uqiklocyxxpaqbwo")
    public suspend fun metrics(`value`: List<MetricSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument The list of metric settings.
     */
    @JvmName("bjnvdeaaoqfcgauh")
    public suspend fun metrics(argument: List<suspend MetricSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument The list of metric settings.
     */
    @JvmName("nmlfqpgdbnanyqws")
    public suspend fun metrics(vararg argument: suspend MetricSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument The list of metric settings.
     */
    @JvmName("ksdyhbajxjrbqqwj")
    public suspend fun metrics(argument: suspend MetricSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricSettingsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values The list of metric settings.
     */
    @JvmName("fvranbvrwolagrye")
    public suspend fun metrics(vararg values: MetricSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("pkomqmyllvdaialk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("gbravaiilvofjwmn")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("lwdldnlcbjqmbnnc")
    public suspend fun serviceBusRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusRuleId = mapped
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("idskmpxqyqknkhco")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("nskijyrbaasrxwdq")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): DiagnosticSettingArgs = DiagnosticSettingArgs(
        eventHubAuthorizationRuleId = eventHubAuthorizationRuleId,
        eventHubName = eventHubName,
        logAnalyticsDestinationType = logAnalyticsDestinationType,
        logs = logs,
        marketplacePartnerId = marketplacePartnerId,
        metrics = metrics,
        name = name,
        resourceUri = resourceUri,
        serviceBusRuleId = serviceBusRuleId,
        storageAccountId = storageAccountId,
        workspaceId = workspaceId,
    )
}
