@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ExportConfiguration].
 */
@PulumiTagMarker
public class ExportConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExportConfigurationArgs = ExportConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExportConfigurationArgsBuilder.() -> Unit) {
        val builder = ExportConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExportConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ExportConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExportConfiguration(builtJavaResource)
    }
}

/**
 * Properties that define a Continuous Export configuration.
 * Azure REST API version: 2015-05-01. Prior API version in Azure Native 1.x: 2015-05-01.
 * ## Example Usage
 * ### ExportConfigurationUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exportConfiguration = new AzureNative.Insights.ExportConfiguration("exportConfiguration", new()
 *     {
 *         DestinationAccountId = "/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob",
 *         DestinationAddress = "https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token",
 *         DestinationStorageLocationId = "eastus",
 *         DestinationStorageSubscriptionId = "subid",
 *         DestinationType = "Blob",
 *         ExportId = "uGOoki0jQsyEs3IdQ83Q4QsNr4=",
 *         IsEnabled = "true",
 *         NotificationQueueEnabled = "false",
 *         NotificationQueueUri = "",
 *         RecordTypes = "Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewExportConfiguration(ctx, "exportConfiguration", &insights.ExportConfigurationArgs{
 * 			DestinationAccountId:             pulumi.String("/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob"),
 * 			DestinationAddress:               pulumi.String("https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token"),
 * 			DestinationStorageLocationId:     pulumi.String("eastus"),
 * 			DestinationStorageSubscriptionId: pulumi.String("subid"),
 * 			DestinationType:                  pulumi.String("Blob"),
 * 			ExportId:                         pulumi.String("uGOoki0jQsyEs3IdQ83Q4QsNr4="),
 * 			IsEnabled:                        pulumi.String("true"),
 * 			NotificationQueueEnabled:         pulumi.String("false"),
 * 			NotificationQueueUri:             pulumi.String(""),
 * 			RecordTypes:                      pulumi.String("Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability"),
 * 			ResourceGroupName:                pulumi.String("my-resource-group"),
 * 			ResourceName:                     pulumi.String("my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ExportConfiguration;
 * import com.pulumi.azurenative.insights.ExportConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exportConfiguration = new ExportConfiguration("exportConfiguration", ExportConfigurationArgs.builder()
 *             .destinationAccountId("/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob")
 *             .destinationAddress("https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token")
 *             .destinationStorageLocationId("eastus")
 *             .destinationStorageSubscriptionId("subid")
 *             .destinationType("Blob")
 *             .exportId("uGOoki0jQsyEs3IdQ83Q4QsNr4=")
 *             .isEnabled("true")
 *             .notificationQueueEnabled("false")
 *             .notificationQueueUri("")
 *             .recordTypes("Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ExportConfiguration myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}
 * ```
 */
public class ExportConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ExportConfiguration,
) : KotlinCustomResource(javaResource, ExportConfigurationMapper) {
    /**
     * The name of the Application Insights component.
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The name of the destination storage container.
     */
    public val containerName: Output<String>
        get() = javaResource.containerName().applyValue({ args0 -> args0 })

    /**
     * The name of destination account.
     */
    public val destinationAccountId: Output<String>
        get() = javaResource.destinationAccountId().applyValue({ args0 -> args0 })

    /**
     * The destination account location ID.
     */
    public val destinationStorageLocationId: Output<String>
        get() = javaResource.destinationStorageLocationId().applyValue({ args0 -> args0 })

    /**
     * The destination storage account subscription ID.
     */
    public val destinationStorageSubscriptionId: Output<String>
        get() = javaResource.destinationStorageSubscriptionId().applyValue({ args0 -> args0 })

    /**
     * The destination type.
     */
    public val destinationType: Output<String>
        get() = javaResource.destinationType().applyValue({ args0 -> args0 })

    /**
     * The unique ID of the export configuration inside an Application Insights component. It is auto generated when the Continuous Export configuration is created.
     */
    public val exportId: Output<String>
        get() = javaResource.exportId().applyValue({ args0 -> args0 })

    /**
     * This indicates current Continuous Export configuration status. The possible values are 'Preparing', 'Success', 'Failure'.
     */
    public val exportStatus: Output<String>
        get() = javaResource.exportStatus().applyValue({ args0 -> args0 })

    /**
     * The instrumentation key of the Application Insights component.
     */
    public val instrumentationKey: Output<String>
        get() = javaResource.instrumentationKey().applyValue({ args0 -> args0 })

    /**
     * This will be 'true' if the Continuous Export configuration is enabled, otherwise it will be 'false'.
     */
    public val isUserEnabled: Output<String>
        get() = javaResource.isUserEnabled().applyValue({ args0 -> args0 })

    /**
     * The last time the Continuous Export configuration started failing.
     */
    public val lastGapTime: Output<String>
        get() = javaResource.lastGapTime().applyValue({ args0 -> args0 })

    /**
     * The last time data was successfully delivered to the destination storage container for this Continuous Export configuration.
     */
    public val lastSuccessTime: Output<String>
        get() = javaResource.lastSuccessTime().applyValue({ args0 -> args0 })

    /**
     * Last time the Continuous Export configuration was updated.
     */
    public val lastUserUpdate: Output<String>
        get() = javaResource.lastUserUpdate().applyValue({ args0 -> args0 })

    /**
     * Deprecated
     */
    public val notificationQueueEnabled: Output<String>?
        get() = javaResource.notificationQueueEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the reason the Continuous Export configuration started failing. It can be 'AzureStorageNotFound' or 'AzureStorageAccessDenied'.
     */
    public val permanentErrorReason: Output<String>
        get() = javaResource.permanentErrorReason().applyValue({ args0 -> args0 })

    /**
     * This comma separated list of document types that will be exported. The possible values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
     */
    public val recordTypes: Output<String>?
        get() = javaResource.recordTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource group of the Application Insights component.
     */
    public val resourceGroup: Output<String>
        get() = javaResource.resourceGroup().applyValue({ args0 -> args0 })

    /**
     * The name of the destination storage account.
     */
    public val storageName: Output<String>
        get() = javaResource.storageName().applyValue({ args0 -> args0 })

    /**
     * The subscription of the Application Insights component.
     */
    public val subscriptionId: Output<String>
        get() = javaResource.subscriptionId().applyValue({ args0 -> args0 })
}

public object ExportConfigurationMapper : ResourceMapper<ExportConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ExportConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ExportConfiguration = ExportConfiguration(
        javaResource
            as com.pulumi.azurenative.insights.ExportConfiguration,
    )
}

/**
 * @see [ExportConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExportConfiguration].
 */
public suspend fun exportConfiguration(
    name: String,
    block: suspend ExportConfigurationResourceBuilder.() -> Unit,
): ExportConfiguration {
    val builder = ExportConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExportConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun exportConfiguration(name: String): ExportConfiguration {
    val builder = ExportConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
