@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ExportConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties that define a Continuous Export configuration.
 * Azure REST API version: 2015-05-01. Prior API version in Azure Native 1.x: 2015-05-01.
 * ## Example Usage
 * ### ExportConfigurationUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exportConfiguration = new AzureNative.Insights.ExportConfiguration("exportConfiguration", new()
 *     {
 *         DestinationAccountId = "/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob",
 *         DestinationAddress = "https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token",
 *         DestinationStorageLocationId = "eastus",
 *         DestinationStorageSubscriptionId = "subid",
 *         DestinationType = "Blob",
 *         ExportId = "uGOoki0jQsyEs3IdQ83Q4QsNr4=",
 *         IsEnabled = "true",
 *         NotificationQueueEnabled = "false",
 *         NotificationQueueUri = "",
 *         RecordTypes = "Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewExportConfiguration(ctx, "exportConfiguration", &insights.ExportConfigurationArgs{
 * 			DestinationAccountId:             pulumi.String("/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob"),
 * 			DestinationAddress:               pulumi.String("https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token"),
 * 			DestinationStorageLocationId:     pulumi.String("eastus"),
 * 			DestinationStorageSubscriptionId: pulumi.String("subid"),
 * 			DestinationType:                  pulumi.String("Blob"),
 * 			ExportId:                         pulumi.String("uGOoki0jQsyEs3IdQ83Q4QsNr4="),
 * 			IsEnabled:                        pulumi.String("true"),
 * 			NotificationQueueEnabled:         pulumi.String("false"),
 * 			NotificationQueueUri:             pulumi.String(""),
 * 			RecordTypes:                      pulumi.String("Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability"),
 * 			ResourceGroupName:                pulumi.String("my-resource-group"),
 * 			ResourceName:                     pulumi.String("my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ExportConfiguration;
 * import com.pulumi.azurenative.insights.ExportConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exportConfiguration = new ExportConfiguration("exportConfiguration", ExportConfigurationArgs.builder()
 *             .destinationAccountId("/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob")
 *             .destinationAddress("https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token")
 *             .destinationStorageLocationId("eastus")
 *             .destinationStorageSubscriptionId("subid")
 *             .destinationType("Blob")
 *             .exportId("uGOoki0jQsyEs3IdQ83Q4QsNr4=")
 *             .isEnabled("true")
 *             .notificationQueueEnabled("false")
 *             .notificationQueueUri("")
 *             .recordTypes("Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ExportConfiguration myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}
 * ```
 * @property destinationAccountId The name of destination storage account.
 * @property destinationAddress The SAS URL for the destination storage container. It must grant write permission.
 * @property destinationStorageLocationId The location ID of the destination storage container.
 * @property destinationStorageSubscriptionId The subscription ID of the destination storage container.
 * @property destinationType The Continuous Export destination type. This has to be 'Blob'.
 * @property exportId The Continuous Export configuration ID. This is unique within a Application Insights component.
 * @property isEnabled Set to 'true' to create a Continuous Export configuration as enabled, otherwise set it to 'false'.
 * @property notificationQueueEnabled Deprecated
 * @property notificationQueueUri Deprecated
 * @property recordTypes The document types to be exported, as comma separated values. Allowed values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 */
public data class ExportConfigurationArgs(
    public val destinationAccountId: Output<String>? = null,
    public val destinationAddress: Output<String>? = null,
    public val destinationStorageLocationId: Output<String>? = null,
    public val destinationStorageSubscriptionId: Output<String>? = null,
    public val destinationType: Output<String>? = null,
    public val exportId: Output<String>? = null,
    public val isEnabled: Output<String>? = null,
    public val notificationQueueEnabled: Output<String>? = null,
    public val notificationQueueUri: Output<String>? = null,
    public val recordTypes: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ExportConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ExportConfigurationArgs =
        com.pulumi.azurenative.insights.ExportConfigurationArgs.builder()
            .destinationAccountId(destinationAccountId?.applyValue({ args0 -> args0 }))
            .destinationAddress(destinationAddress?.applyValue({ args0 -> args0 }))
            .destinationStorageLocationId(destinationStorageLocationId?.applyValue({ args0 -> args0 }))
            .destinationStorageSubscriptionId(destinationStorageSubscriptionId?.applyValue({ args0 -> args0 }))
            .destinationType(destinationType?.applyValue({ args0 -> args0 }))
            .exportId(exportId?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .notificationQueueEnabled(notificationQueueEnabled?.applyValue({ args0 -> args0 }))
            .notificationQueueUri(notificationQueueUri?.applyValue({ args0 -> args0 }))
            .recordTypes(recordTypes?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportConfigurationArgs].
 */
@PulumiTagMarker
public class ExportConfigurationArgsBuilder internal constructor() {
    private var destinationAccountId: Output<String>? = null

    private var destinationAddress: Output<String>? = null

    private var destinationStorageLocationId: Output<String>? = null

    private var destinationStorageSubscriptionId: Output<String>? = null

    private var destinationType: Output<String>? = null

    private var exportId: Output<String>? = null

    private var isEnabled: Output<String>? = null

    private var notificationQueueEnabled: Output<String>? = null

    private var notificationQueueUri: Output<String>? = null

    private var recordTypes: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of destination storage account.
     */
    @JvmName("xpsjndvvppblbmkv")
    public suspend fun destinationAccountId(`value`: Output<String>) {
        this.destinationAccountId = value
    }

    /**
     * @param value The SAS URL for the destination storage container. It must grant write permission.
     */
    @JvmName("fevdpluvaafhsysp")
    public suspend fun destinationAddress(`value`: Output<String>) {
        this.destinationAddress = value
    }

    /**
     * @param value The location ID of the destination storage container.
     */
    @JvmName("qiscyypyoaqiyrfc")
    public suspend fun destinationStorageLocationId(`value`: Output<String>) {
        this.destinationStorageLocationId = value
    }

    /**
     * @param value The subscription ID of the destination storage container.
     */
    @JvmName("ravmnmfmjpjlmyck")
    public suspend fun destinationStorageSubscriptionId(`value`: Output<String>) {
        this.destinationStorageSubscriptionId = value
    }

    /**
     * @param value The Continuous Export destination type. This has to be 'Blob'.
     */
    @JvmName("rhfjfsumbmxynygs")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value The Continuous Export configuration ID. This is unique within a Application Insights component.
     */
    @JvmName("dvjoqkhapqbrqpik")
    public suspend fun exportId(`value`: Output<String>) {
        this.exportId = value
    }

    /**
     * @param value Set to 'true' to create a Continuous Export configuration as enabled, otherwise set it to 'false'.
     */
    @JvmName("renljjccofoafnvj")
    public suspend fun isEnabled(`value`: Output<String>) {
        this.isEnabled = value
    }

    /**
     * @param value Deprecated
     */
    @JvmName("lehnkwlslidmltjj")
    public suspend fun notificationQueueEnabled(`value`: Output<String>) {
        this.notificationQueueEnabled = value
    }

    /**
     * @param value Deprecated
     */
    @JvmName("aioisikomkyawrya")
    public suspend fun notificationQueueUri(`value`: Output<String>) {
        this.notificationQueueUri = value
    }

    /**
     * @param value The document types to be exported, as comma separated values. Allowed values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
     */
    @JvmName("itbhlgbtfmtsaupm")
    public suspend fun recordTypes(`value`: Output<String>) {
        this.recordTypes = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swkfywffdyuuhxxx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("gkpnwdgacfetirfr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of destination storage account.
     */
    @JvmName("cqacwutgladxcuma")
    public suspend fun destinationAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAccountId = mapped
    }

    /**
     * @param value The SAS URL for the destination storage container. It must grant write permission.
     */
    @JvmName("disbttcwqsyddfra")
    public suspend fun destinationAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddress = mapped
    }

    /**
     * @param value The location ID of the destination storage container.
     */
    @JvmName("cvpqwtmcfrlmsflk")
    public suspend fun destinationStorageLocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationStorageLocationId = mapped
    }

    /**
     * @param value The subscription ID of the destination storage container.
     */
    @JvmName("xlndatquspdregkr")
    public suspend fun destinationStorageSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationStorageSubscriptionId = mapped
    }

    /**
     * @param value The Continuous Export destination type. This has to be 'Blob'.
     */
    @JvmName("htnvbrbrpobqxnqf")
    public suspend fun destinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value The Continuous Export configuration ID. This is unique within a Application Insights component.
     */
    @JvmName("amqrsywoemftrika")
    public suspend fun exportId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportId = mapped
    }

    /**
     * @param value Set to 'true' to create a Continuous Export configuration as enabled, otherwise set it to 'false'.
     */
    @JvmName("ijhqscwndadehqnd")
    public suspend fun isEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Deprecated
     */
    @JvmName("hfveiolhuqxdlbsq")
    public suspend fun notificationQueueEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationQueueEnabled = mapped
    }

    /**
     * @param value Deprecated
     */
    @JvmName("nacmkstvejpfbfwi")
    public suspend fun notificationQueueUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationQueueUri = mapped
    }

    /**
     * @param value The document types to be exported, as comma separated values. Allowed values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
     */
    @JvmName("rxskovxjcvkkpmll")
    public suspend fun recordTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordTypes = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dftnrgxvaicqjbdt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("qoqguwtimmssgdse")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ExportConfigurationArgs = ExportConfigurationArgs(
        destinationAccountId = destinationAccountId,
        destinationAddress = destinationAddress,
        destinationStorageLocationId = destinationStorageLocationId,
        destinationStorageSubscriptionId = destinationStorageSubscriptionId,
        destinationType = destinationType,
        exportId = exportId,
        isEnabled = isEnabled,
        notificationQueueEnabled = notificationQueueEnabled,
        notificationQueueUri = notificationQueueUri,
        recordTypes = recordTypes,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
