@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ManagementGroupLogSettingsResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.insights.kotlin.outputs.ManagementGroupLogSettingsResponse.Companion.toKotlin as managementGroupLogSettingsResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagementGroupDiagnosticSetting].
 */
@PulumiTagMarker
public class ManagementGroupDiagnosticSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementGroupDiagnosticSettingArgs = ManagementGroupDiagnosticSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementGroupDiagnosticSettingArgsBuilder.() -> Unit) {
        val builder = ManagementGroupDiagnosticSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagementGroupDiagnosticSetting {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementGroupDiagnosticSetting(builtJavaResource)
    }
}

/**
 * The management group diagnostic setting resource.
 * Azure REST API version: 2021-05-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2020-01-01-preview.
 * ## Example Usage
 * ### Creates or Updates the management group diagnostic setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupDiagnosticSetting = new AzureNative.Insights.ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ManagementGroupLogSettingsArgs
 *             {
 *                 CategoryGroup = "allLogs",
 *                 Enabled = true,
 *             },
 *         },
 *         ManagementGroupId = "testChildMG7",
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "setting1",
 *         StorageAccountId = "/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5",
 *         WorkspaceId = "/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewManagementGroupDiagnosticSetting(ctx, "managementGroupDiagnosticSetting", &insights.ManagementGroupDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.ManagementGroupLogSettingsArgs{
 * 				{
 * 					CategoryGroup: pulumi.String("allLogs"),
 * 					Enabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			ManagementGroupId:    pulumi.String("testChildMG7"),
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("setting1"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5"),
 * 			WorkspaceId:          pulumi.String("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupDiagnosticSetting = new ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", ManagementGroupDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("categoryGroup", "allLogs"),
 *                 Map.entry("enabled", true)
 *             ))
 *             .managementGroupId("testChildMG7")
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("setting1")
 *             .storageAccountId("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5")
 *             .workspaceId("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or Updates the management group diagnostic setting for category
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupDiagnosticSetting = new AzureNative.Insights.ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ManagementGroupLogSettingsArgs
 *             {
 *                 Category = "Administrative",
 *                 Enabled = true,
 *             },
 *             new AzureNative.Insights.Inputs.ManagementGroupLogSettingsArgs
 *             {
 *                 Category = "Policy",
 *                 Enabled = true,
 *             },
 *         },
 *         ManagementGroupId = "testChildMG7",
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "setting1",
 *         StorageAccountId = "/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5",
 *         WorkspaceId = "/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewManagementGroupDiagnosticSetting(ctx, "managementGroupDiagnosticSetting", &insights.ManagementGroupDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.ManagementGroupLogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("Administrative"),
 * 					Enabled:  pulumi.Bool(true),
 * 				},
 * 				{
 * 					Category: pulumi.String("Policy"),
 * 					Enabled:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			ManagementGroupId:    pulumi.String("testChildMG7"),
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("setting1"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5"),
 * 			WorkspaceId:          pulumi.String("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupDiagnosticSetting = new ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", ManagementGroupDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(
 *                 Map.ofEntries(
 *                     Map.entry("category", "Administrative"),
 *                     Map.entry("enabled", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("category", "Policy"),
 *                     Map.entry("enabled", true)
 *                 ))
 *             .managementGroupId("testChildMG7")
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("setting1")
 *             .storageAccountId("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5")
 *             .workspaceId("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ManagementGroupDiagnosticSetting setting1 /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Insights/diagnosticSettings/{name}
 * ```
 */
public class ManagementGroupDiagnosticSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting,
) : KotlinCustomResource(javaResource, ManagementGroupDiagnosticSettingMapper) {
    /**
     * The resource Id for the event hub authorization rule.
     */
    public val eventHubAuthorizationRuleId: Output<String>?
        get() = javaResource.eventHubAuthorizationRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the event hub. If none is specified, the default event hub will be selected.
     */
    public val eventHubName: Output<String>?
        get() = javaResource.eventHubName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of logs settings.
     */
    public val logs: Output<List<ManagementGroupLogSettingsResponse>>?
        get() = javaResource.logs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> managementGroupLogSettingsResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    public val marketplacePartnerId: Output<String>?
        get() = javaResource.marketplacePartnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    public val serviceBusRuleId: Output<String>?
        get() = javaResource.serviceBusRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    public val workspaceId: Output<String>?
        get() = javaResource.workspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ManagementGroupDiagnosticSettingMapper :
    ResourceMapper<ManagementGroupDiagnosticSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting::class == javaResource::class

    override fun map(javaResource: Resource): ManagementGroupDiagnosticSetting =
        ManagementGroupDiagnosticSetting(
            javaResource as
                com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting,
        )
}

/**
 * @see [ManagementGroupDiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementGroupDiagnosticSetting].
 */
public suspend fun managementGroupDiagnosticSetting(
    name: String,
    block: suspend ManagementGroupDiagnosticSettingResourceBuilder.() -> Unit,
):
    ManagementGroupDiagnosticSetting {
    val builder = ManagementGroupDiagnosticSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementGroupDiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementGroupDiagnosticSetting(name: String): ManagementGroupDiagnosticSetting {
    val builder = ManagementGroupDiagnosticSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
