@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.MetricAlertArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.MetricAlertActionArgs
import com.pulumi.azurenative.insights.kotlin.inputs.MetricAlertActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The metric alert resource.
 * Azure REST API version: 2018-03-01. Prior API version in Azure Native 1.x: 2018-03-01.
 * ## Example Usage
 * ### Create or update a dynamic alert rule for Multiple Resources
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.DynamicMetricCriteriaArgs
 *                 {
 *                     AlertSensitivity = "Medium",
 *                     CriterionType = "DynamicThresholdCriterion",
 *                     Dimensions = new() { },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.DynamicThresholdFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 4,
 *                         NumberOfEvaluationPeriods = 4,
 *                     },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterOrLessThan",
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertOnMultipleResources",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.DynamicMetricCriteria{
 * 						AlertSensitivity: "Medium",
 * 						CriterionType:    "DynamicThresholdCriterion",
 * 						Dimensions:       []insights.MetricDimension{},
 * 						FailingPeriods: insights.DynamicThresholdFailingPeriods{
 * 							MinFailingPeriodsToAlert:  4,
 * 							NumberOfEvaluationPeriods: 4,
 * 						},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterOrLessThan",
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertOnMultipleResources"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("alertSensitivity", "Medium"),
 *                     Map.entry("criterionType", "DynamicThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("failingPeriods", Map.ofEntries(
 *                         Map.entry("minFailingPeriodsToAlert", 4),
 *                         Map.entry("numberOfEvaluationPeriods", 4)
 *                     )),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterOrLessThan"),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertOnMultipleResources")
 *             .scopes(
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a dynamic alert rule for Single Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.DynamicMetricCriteriaArgs
 *                 {
 *                     AlertSensitivity = "Medium",
 *                     CriterionType = "DynamicThresholdCriterion",
 *                     Dimensions = new() { },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.DynamicThresholdFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 4,
 *                         NumberOfEvaluationPeriods = 4,
 *                     },
 *                     IgnoreDataBefore = "2019-04-04T21:00:00.000Z",
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterOrLessThan",
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "chiricutin",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.DynamicMetricCriteria{
 * 						AlertSensitivity: "Medium",
 * 						CriterionType:    "DynamicThresholdCriterion",
 * 						Dimensions:       []insights.MetricDimension{},
 * 						FailingPeriods: insights.DynamicThresholdFailingPeriods{
 * 							MinFailingPeriodsToAlert:  4,
 * 							NumberOfEvaluationPeriods: 4,
 * 						},
 * 						IgnoreDataBefore: "2019-04-04T21:00:00.000Z",
 * 						MetricName:       "Percentage CPU",
 * 						MetricNamespace:  "microsoft.compute/virtualmachines",
 * 						Name:             "High_CPU_80",
 * 						Operator:         "GreaterOrLessThan",
 * 						TimeAggregation:  "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("chiricutin"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme"),
 * 			},
 * 			Severity:   pulumi.Int(3),
 * 			Tags:       nil,
 * 			WindowSize: pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("alertSensitivity", "Medium"),
 *                     Map.entry("criterionType", "DynamicThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("failingPeriods", Map.ofEntries(
 *                         Map.entry("minFailingPeriodsToAlert", 4),
 *                         Map.entry("numberOfEvaluationPeriods", 4)
 *                     )),
 *                     Map.entry("ignoreDataBefore", "2019-04-04T21:00:00.000Z"),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterOrLessThan"),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("chiricutin")
 *             .scopes("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")
 *             .severity(3)
 *             .tags()
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a web test alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[] {},
 *         Criteria = new AzureNative.Insights.Inputs.WebtestLocationAvailabilityCriteriaArgs
 *         {
 *             ComponentId = "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example",
 *             FailedLocationCount = 2,
 *             OdataType = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria",
 *             WebTestId = "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 *         },
 *         Description = "Automatically created alert rule for availability test \"component-example\" a",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "rg-example",
 *         RuleName = "webtest-name-example",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 *             "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example",
 *         },
 *         Severity = 4,
 *         Tags =
 *         {
 *             { "hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example", "Resource" },
 *             { "hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example", "Resource" },
 *         },
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: insights.MetricAlertActionArray{},
 * 			Criteria: insights.WebtestLocationAvailabilityCriteria{
 * 				ComponentId:         "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example",
 * 				FailedLocationCount: 2,
 * 				OdataType:           "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria",
 * 				WebTestId:           "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 * 			},
 * 			Description:         pulumi.String("Automatically created alert rule for availability test \"component-example\" a"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("rg-example"),
 * 			RuleName:            pulumi.String("webtest-name-example"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example"),
 * 				pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example"),
 * 			},
 * 			Severity: pulumi.Int(4),
 * 			Tags: pulumi.StringMap{
 * 				"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example": pulumi.String("Resource"),
 * 				"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example":      pulumi.String("Resource"),
 * 			},
 * 			WindowSize: pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions()
 *             .criteria(Map.ofEntries(
 *                 Map.entry("componentId", "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example"),
 *                 Map.entry("failedLocationCount", 2),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"),
 *                 Map.entry("webTestId", "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example")
 *             ))
 *             .description("Automatically created alert rule for availability test \"component-example\" a")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("rg-example")
 *             .ruleName("webtest-name-example")
 *             .scopes(
 *                 "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 *                 "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example")
 *             .severity(4)
 *             .tags(Map.ofEntries(
 *                 Map.entry("hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example", "Resource"),
 *                 Map.entry("hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example", "Resource")
 *             ))
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule for Multiple Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertOnMultipleResources",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertOnMultipleResources"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertOnMultipleResources")
 *             .scopes(
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule for Single Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertSingleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "\\Processor(_Total)\\% Processor Time",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "Pt1m",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "chiricutin",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         WindowSize = "Pt15m",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertSingleResourceMultipleMetricCriteria{
 * 				AllOf: []insights.MetricCriteria{
 * 					{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "\\Processor(_Total)\\% Processor Time",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("Pt1m"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("chiricutin"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme"),
 * 			},
 * 			Severity:   pulumi.Int(3),
 * 			Tags:       nil,
 * 			WindowSize: pulumi.String("Pt15m"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "\\Processor(_Total)\\% Processor Time"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("Pt1m")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("chiricutin")
 *             .scopes("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")
 *             .severity(3)
 *             .tags()
 *             .windowSize("Pt15m")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule on Resource group(s)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest1",
 *         RuleName = "MetricAlertAtResourceGroupLevel",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1",
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest1"),
 * 			RuleName:            pulumi.String("MetricAlertAtResourceGroupLevel"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1"),
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest1")
 *             .ruleName("MetricAlertAtResourceGroupLevel")
 *             .scopes(
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1",
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule on Subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertAtSubscriptionLevel",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertAtSubscriptionLevel"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertAtSubscriptionLevel")
 *             .scopes("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rules with dimensions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.MetricDimensionArgs
 *                         {
 *                             Name = "ActivityName",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                         new AzureNative.Insights.Inputs.MetricDimensionArgs
 *                         {
 *                             Name = "StatusCode",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "200",
 *                             },
 *                         },
 *                     },
 *                     MetricName = "Availability",
 *                     MetricNamespace = "Microsoft.KeyVault/vaults",
 *                     Name = "Metric1",
 *                     Operator = "GreaterThan",
 *                     Threshold = 55,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1H",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertOnMultipleDimensions",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         WindowSize = "P1D",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType: "StaticThresholdCriterion",
 * 						Dimensions: []insights.MetricDimension{
 * 							{
 * 								Name:     "ActivityName",
 * 								Operator: "Include",
 * 								Values: []string{
 * 									"*",
 * 								},
 * 							},
 * 							{
 * 								Name:     "StatusCode",
 * 								Operator: "Include",
 * 								Values: []string{
 * 									"200",
 * 								},
 * 							},
 * 						},
 * 						MetricName:      "Availability",
 * 						MetricNamespace: "Microsoft.KeyVault/vaults",
 * 						Name:            "Metric1",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       55,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1H"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertOnMultipleDimensions"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource"),
 * 			},
 * 			Severity:   pulumi.Int(3),
 * 			Tags:       nil,
 * 			WindowSize: pulumi.String("P1D"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions",
 *                         Map.ofEntries(
 *                             Map.entry("name", "ActivityName"),
 *                             Map.entry("operator", "Include"),
 *                             Map.entry("values", "*")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("name", "StatusCode"),
 *                             Map.entry("operator", "Include"),
 *                             Map.entry("values", "200")
 *                         )),
 *                     Map.entry("metricName", "Availability"),
 *                     Map.entry("metricNamespace", "Microsoft.KeyVault/vaults"),
 *                     Map.entry("name", "Metric1"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 55),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1H")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertOnMultipleDimensions")
 *             .scopes("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource")
 *             .severity(3)
 *             .tags()
 *             .windowSize("P1D")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:MetricAlert webtest-name-example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}
 * ```
 * @property actions the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property autoMitigate the flag that indicates whether the alert should be auto resolved or not. The default is true.
 * @property criteria defines the specific alert criteria information.
 * @property description the description of the metric alert that will be included in the alert email.
 * @property enabled the flag that indicates whether the metric alert is enabled.
 * @property evaluationFrequency how often the metric alert is evaluated represented in ISO 8601 duration format.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The name of the rule.
 * @property scopes the list of resource id's that this metric alert is scoped to.
 * @property severity Alert severity {0, 1, 2, 3, 4}
 * @property tags Resource tags
 * @property targetResourceRegion the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
 * @property targetResourceType the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
 */
public data class MetricAlertArgs(
    public val actions: Output<List<MetricAlertActionArgs>>? = null,
    public val autoMitigate: Output<Boolean>? = null,
    public val criteria: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val evaluationFrequency: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
    public val severity: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceRegion: Output<String>? = null,
    public val targetResourceType: Output<String>? = null,
    public val windowSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.MetricAlertArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.MetricAlertArgs =
        com.pulumi.azurenative.insights.MetricAlertArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoMitigate(autoMitigate?.applyValue({ args0 -> args0 }))
            .criteria(criteria?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .evaluationFrequency(evaluationFrequency?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .severity(severity?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceRegion(targetResourceRegion?.applyValue({ args0 -> args0 }))
            .targetResourceType(targetResourceType?.applyValue({ args0 -> args0 }))
            .windowSize(windowSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricAlertArgs].
 */
@PulumiTagMarker
public class MetricAlertArgsBuilder internal constructor() {
    private var actions: Output<List<MetricAlertActionArgs>>? = null

    private var autoMitigate: Output<Boolean>? = null

    private var criteria: Output<Any>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var evaluationFrequency: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    private var severity: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceRegion: Output<String>? = null

    private var targetResourceType: Output<String>? = null

    private var windowSize: Output<String>? = null

    /**
     * @param value the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("wwgfyivobbltsstn")
    public suspend fun actions(`value`: Output<List<MetricAlertActionArgs>>) {
        this.actions = value
    }

    @JvmName("urstedkwapierkpt")
    public suspend fun actions(vararg values: Output<MetricAlertActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("hxfhdpfhvdesedbm")
    public suspend fun actions(values: List<Output<MetricAlertActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value the flag that indicates whether the alert should be auto resolved or not. The default is true.
     */
    @JvmName("nxsocqtiomqnmykm")
    public suspend fun autoMitigate(`value`: Output<Boolean>) {
        this.autoMitigate = value
    }

    /**
     * @param value defines the specific alert criteria information.
     */
    @JvmName("phtqfntbhwvbhbrp")
    public suspend fun criteria(`value`: Output<Any>) {
        this.criteria = value
    }

    /**
     * @param value the description of the metric alert that will be included in the alert email.
     */
    @JvmName("ulpenbiswsfrqceb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value the flag that indicates whether the metric alert is enabled.
     */
    @JvmName("fcahixubcwjbbdgu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value how often the metric alert is evaluated represented in ISO 8601 duration format.
     */
    @JvmName("duhivjtrnlbnfddb")
    public suspend fun evaluationFrequency(`value`: Output<String>) {
        this.evaluationFrequency = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("pfdqoyphpwjntqhd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kxxbapdxupwbbeww")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("vcxklmdbrdgjsden")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value the list of resource id's that this metric alert is scoped to.
     */
    @JvmName("yckqrqwxwrpdpfwl")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("qiuhxrultowdixyx")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values the list of resource id's that this metric alert is scoped to.
     */
    @JvmName("ilhggmwopdckwkqt")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Alert severity {0, 1, 2, 3, 4}
     */
    @JvmName("swgkacoivhlcjrqv")
    public suspend fun severity(`value`: Output<Int>) {
        this.severity = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("fvssmvvcibdimkrv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     */
    @JvmName("mvrqbfkxcoipgvsa")
    public suspend fun targetResourceRegion(`value`: Output<String>) {
        this.targetResourceRegion = value
    }

    /**
     * @param value the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     */
    @JvmName("bqcupemvahhaarkb")
    public suspend fun targetResourceType(`value`: Output<String>) {
        this.targetResourceType = value
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     */
    @JvmName("udlqbevixjoibhml")
    public suspend fun windowSize(`value`: Output<String>) {
        this.windowSize = value
    }

    /**
     * @param value the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("gqrwjpgdjoaxpeoe")
    public suspend fun actions(`value`: List<MetricAlertActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("aeieaklvijvfwhdd")
    public suspend fun actions(argument: List<suspend MetricAlertActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricAlertActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("mvxosrokmrdxvoky")
    public suspend fun actions(vararg argument: suspend MetricAlertActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricAlertActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("eswdbtfvfprtbysq")
    public suspend fun actions(argument: suspend MetricAlertActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricAlertActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("akuivgcwqyuvixuv")
    public suspend fun actions(vararg values: MetricAlertActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value the flag that indicates whether the alert should be auto resolved or not. The default is true.
     */
    @JvmName("rqujldfklvgcsmlg")
    public suspend fun autoMitigate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMitigate = mapped
    }

    /**
     * @param value defines the specific alert criteria information.
     */
    @JvmName("oawtjwsqfbwkdxqs")
    public suspend fun criteria(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param value the description of the metric alert that will be included in the alert email.
     */
    @JvmName("vvsudsubiwrfvsik")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value the flag that indicates whether the metric alert is enabled.
     */
    @JvmName("tcycjhgtokckyuyy")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value how often the metric alert is evaluated represented in ISO 8601 duration format.
     */
    @JvmName("rgoorcqtylanamqd")
    public suspend fun evaluationFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationFrequency = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("iyordreqanfkggfw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("phapewafoyisdevd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("gkioqesrgvektvbh")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value the list of resource id's that this metric alert is scoped to.
     */
    @JvmName("uomfimuoxfjvqrtf")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values the list of resource id's that this metric alert is scoped to.
     */
    @JvmName("jyusgtnmnoymuokt")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Alert severity {0, 1, 2, 3, 4}
     */
    @JvmName("xknapxsokngkjhyt")
    public suspend fun severity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ufwpcufxnnlbhpbo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("hkdfcumugxksycke")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     */
    @JvmName("mijxtenddjwhvtji")
    public suspend fun targetResourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceRegion = mapped
    }

    /**
     * @param value the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     */
    @JvmName("rpeyfepfkocgohmj")
    public suspend fun targetResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceType = mapped
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     */
    @JvmName("ouwmfxkolyhmdhit")
    public suspend fun windowSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowSize = mapped
    }

    internal fun build(): MetricAlertArgs = MetricAlertArgs(
        actions = actions,
        autoMitigate = autoMitigate,
        criteria = criteria,
        description = description,
        enabled = enabled,
        evaluationFrequency = evaluationFrequency,
        location = location,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        scopes = scopes,
        severity = severity,
        tags = tags,
        targetResourceRegion = targetResourceRegion,
        targetResourceType = targetResourceType,
        windowSize = windowSize,
    )
}
