@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ActionsResponse
import com.pulumi.azurenative.insights.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.insights.kotlin.outputs.RuleResolveConfigurationResponse
import com.pulumi.azurenative.insights.kotlin.outputs.ScheduledQueryRuleCriteriaResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.ActionsResponse.Companion.toKotlin as actionsResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.RuleResolveConfigurationResponse.Companion.toKotlin as ruleResolveConfigurationResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.ScheduledQueryRuleCriteriaResponse.Companion.toKotlin as scheduledQueryRuleCriteriaResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ScheduledQueryRule].
 */
@PulumiTagMarker
public class ScheduledQueryRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledQueryRuleArgs = ScheduledQueryRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledQueryRuleArgsBuilder.() -> Unit) {
        val builder = ScheduledQueryRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScheduledQueryRule {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ScheduledQueryRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScheduledQueryRule(builtJavaResource)
    }
}

/**
 * The scheduled query rule resource.
 * Azure REST API version: 2023-03-15-preview. Prior API version in Azure Native 1.x: 2018-04-16.
 * Other available API versions: 2018-04-16, 2020-05-01-preview, 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a scheduled query rule for Single Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledQueryRule = new AzureNative.Insights.ScheduledQueryRule("scheduledQueryRule", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionsArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup",
 *             },
 *             CustomProperties =
 *             {
 *                 { "key11", "value11" },
 *                 { "key12", "value12" },
 *             },
 *         },
 *         CheckWorkspaceAlertsStorageConfigured = true,
 *         Criteria = new AzureNative.Insights.Inputs.ScheduledQueryRuleCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ConditionArgs
 *                 {
 *                     Dimensions = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "ComputerIp",
 *                             Operator = "Exclude",
 *                             Values = new[]
 *                             {
 *                                 "192.168.1.1",
 *                             },
 *                         },
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "OSType",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                     },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.ConditionFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 1,
 *                         NumberOfEvaluationPeriods = 1,
 *                     },
 *                     MetricMeasureColumn = "% Processor Time",
 *                     Operator = "GreaterThan",
 *                     Query = "Perf | where ObjectName == \"Processor\"",
 *                     ResourceIdColumn = "resourceId",
 *                     Threshold = 70,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *         },
 *         Description = "Performance rule",
 *         Enabled = true,
 *         EvaluationFrequency = "PT5M",
 *         Location = "eastus",
 *         MuteActionsDuration = "PT30M",
 *         ResourceGroupName = "QueryResourceGroupName",
 *         RuleName = "perf",
 *         RuleResolveConfiguration = new AzureNative.Insights.Inputs.RuleResolveConfigurationArgs
 *         {
 *             AutoResolved = true,
 *             TimeToResolve = "PT10M",
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1",
 *         },
 *         Severity = 4,
 *         SkipQueryValidation = true,
 *         WindowSize = "PT10M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewScheduledQueryRule(ctx, "scheduledQueryRule", &insights.ScheduledQueryRuleArgs{
 * Actions: &insights.ActionsArgs{
 * ActionGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 * },
 * CustomProperties: pulumi.StringMap{
 * "key11": pulumi.String("value11"),
 * "key12": pulumi.String("value12"),
 * },
 * },
 * CheckWorkspaceAlertsStorageConfigured: pulumi.Bool(true),
 * Criteria: insights.ScheduledQueryRuleCriteriaResponse{
 * AllOf: insights.ConditionArray{
 * interface{}{
 * Dimensions: insights.DimensionArray{
 * &insights.DimensionArgs{
 * Name: pulumi.String("ComputerIp"),
 * Operator: pulumi.String("Exclude"),
 * Values: pulumi.StringArray{
 * pulumi.String("192.168.1.1"),
 * },
 * },
 * &insights.DimensionArgs{
 * Name: pulumi.String("OSType"),
 * Operator: pulumi.String("Include"),
 * Values: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * },
 * },
 * FailingPeriods: &insights.ConditionFailingPeriodsArgs{
 * MinFailingPeriodsToAlert: pulumi.Float64(1),
 * NumberOfEvaluationPeriods: pulumi.Float64(1),
 * },
 * MetricMeasureColumn: pulumi.String("% Processor Time"),
 * Operator: pulumi.String("GreaterThan"),
 * Query: pulumi.String("Perf | where ObjectName == \"Processor\""),
 * ResourceIdColumn: pulumi.String("resourceId"),
 * Threshold: pulumi.Float64(70),
 * TimeAggregation: pulumi.String("Average"),
 * },
 * },
 * },
 * Description: pulumi.String("Performance rule"),
 * Enabled: pulumi.Bool(true),
 * EvaluationFrequency: pulumi.String("PT5M"),
 * Location: pulumi.String("eastus"),
 * MuteActionsDuration: pulumi.String("PT30M"),
 * ResourceGroupName: pulumi.String("QueryResourceGroupName"),
 * RuleName: pulumi.String("perf"),
 * RuleResolveConfiguration: &insights.RuleResolveConfigurationArgs{
 * AutoResolved: pulumi.Bool(true),
 * TimeToResolve: pulumi.String("PT10M"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1"),
 * },
 * Severity: pulumi.Float64(4),
 * SkipQueryValidation: pulumi.Bool(true),
 * WindowSize: pulumi.String("PT10M"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ScheduledQueryRule;
 * import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledQueryRule = new ScheduledQueryRule("scheduledQueryRule", ScheduledQueryRuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroups", "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .checkWorkspaceAlertsStorageConfigured(true)
 *             .criteria(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("dimensions",
 *                     Map.ofEntries(
 *                         Map.entry("name", "ComputerIp"),
 *                         Map.entry("operator", "Exclude"),
 *                         Map.entry("values", "192.168.1.1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "OSType"),
 *                         Map.entry("operator", "Include"),
 *                         Map.entry("values", "*")
 *                     )),
 *                 Map.entry("failingPeriods", Map.ofEntries(
 *                     Map.entry("minFailingPeriodsToAlert", 1),
 *                     Map.entry("numberOfEvaluationPeriods", 1)
 *                 )),
 *                 Map.entry("metricMeasureColumn", "% Processor Time"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("query", "Perf | where ObjectName == \"Processor\""),
 *                 Map.entry("resourceIdColumn", "resourceId"),
 *                 Map.entry("threshold", 70),
 *                 Map.entry("timeAggregation", "Average")
 *             )))
 *             .description("Performance rule")
 *             .enabled(true)
 *             .evaluationFrequency("PT5M")
 *             .location("eastus")
 *             .muteActionsDuration("PT30M")
 *             .resourceGroupName("QueryResourceGroupName")
 *             .ruleName("perf")
 *             .ruleResolveConfiguration(Map.ofEntries(
 *                 Map.entry("autoResolved", true),
 *                 Map.entry("timeToResolve", "PT10M")
 *             ))
 *             .scopes("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1")
 *             .severity(4)
 *             .skipQueryValidation(true)
 *             .windowSize("PT10M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a scheduled query rule on Resource group(s)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledQueryRule = new AzureNative.Insights.ScheduledQueryRule("scheduledQueryRule", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionsArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup",
 *             },
 *             CustomProperties =
 *             {
 *                 { "key11", "value11" },
 *                 { "key12", "value12" },
 *             },
 *         },
 *         CheckWorkspaceAlertsStorageConfigured = true,
 *         Criteria = new AzureNative.Insights.Inputs.ScheduledQueryRuleCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ConditionArgs
 *                 {
 *                     Dimensions = new[] {},
 *                     FailingPeriods = new AzureNative.Insights.Inputs.ConditionFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 1,
 *                         NumberOfEvaluationPeriods = 1,
 *                     },
 *                     Operator = "GreaterThan",
 *                     Query = "Heartbeat",
 *                     Threshold = 360,
 *                     TimeAggregation = "Count",
 *                 },
 *             },
 *         },
 *         Description = "Health check rule",
 *         Enabled = true,
 *         EvaluationFrequency = "PT5M",
 *         Location = "eastus",
 *         MuteActionsDuration = "PT30M",
 *         ResourceGroupName = "QueryResourceGroupName",
 *         RuleName = "heartbeat",
 *         RuleResolveConfiguration = new AzureNative.Insights.Inputs.RuleResolveConfigurationArgs
 *         {
 *             AutoResolved = true,
 *             TimeToResolve = "PT10M",
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1",
 *         },
 *         Severity = 4,
 *         SkipQueryValidation = true,
 *         TargetResourceTypes = new[]
 *         {
 *             "Microsoft.Compute/virtualMachines",
 *         },
 *         WindowSize = "PT10M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewScheduledQueryRule(ctx, "scheduledQueryRule", &insights.ScheduledQueryRuleArgs{
 * Actions: &insights.ActionsArgs{
 * ActionGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 * },
 * CustomProperties: pulumi.StringMap{
 * "key11": pulumi.String("value11"),
 * "key12": pulumi.String("value12"),
 * },
 * },
 * CheckWorkspaceAlertsStorageConfigured: pulumi.Bool(true),
 * Criteria: insights.ScheduledQueryRuleCriteriaResponse{
 * AllOf: insights.ConditionArray{
 * interface{}{
 * Dimensions: insights.DimensionArray{
 * },
 * FailingPeriods: &insights.ConditionFailingPeriodsArgs{
 * MinFailingPeriodsToAlert: pulumi.Float64(1),
 * NumberOfEvaluationPeriods: pulumi.Float64(1),
 * },
 * Operator: pulumi.String("GreaterThan"),
 * Query: pulumi.String("Heartbeat"),
 * Threshold: pulumi.Float64(360),
 * TimeAggregation: pulumi.String("Count"),
 * },
 * },
 * },
 * Description: pulumi.String("Health check rule"),
 * Enabled: pulumi.Bool(true),
 * EvaluationFrequency: pulumi.String("PT5M"),
 * Location: pulumi.String("eastus"),
 * MuteActionsDuration: pulumi.String("PT30M"),
 * ResourceGroupName: pulumi.String("QueryResourceGroupName"),
 * RuleName: pulumi.String("heartbeat"),
 * RuleResolveConfiguration: &insights.RuleResolveConfigurationArgs{
 * AutoResolved: pulumi.Bool(true),
 * TimeToResolve: pulumi.String("PT10M"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1"),
 * },
 * Severity: pulumi.Float64(4),
 * SkipQueryValidation: pulumi.Bool(true),
 * TargetResourceTypes: pulumi.StringArray{
 * pulumi.String("Microsoft.Compute/virtualMachines"),
 * },
 * WindowSize: pulumi.String("PT10M"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ScheduledQueryRule;
 * import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledQueryRule = new ScheduledQueryRule("scheduledQueryRule", ScheduledQueryRuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroups", "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .checkWorkspaceAlertsStorageConfigured(true)
 *             .criteria(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("dimensions", ),
 *                 Map.entry("failingPeriods", Map.ofEntries(
 *                     Map.entry("minFailingPeriodsToAlert", 1),
 *                     Map.entry("numberOfEvaluationPeriods", 1)
 *                 )),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("query", "Heartbeat"),
 *                 Map.entry("threshold", 360),
 *                 Map.entry("timeAggregation", "Count")
 *             )))
 *             .description("Health check rule")
 *             .enabled(true)
 *             .evaluationFrequency("PT5M")
 *             .location("eastus")
 *             .muteActionsDuration("PT30M")
 *             .resourceGroupName("QueryResourceGroupName")
 *             .ruleName("heartbeat")
 *             .ruleResolveConfiguration(Map.ofEntries(
 *                 Map.entry("autoResolved", true),
 *                 Map.entry("timeToResolve", "PT10M")
 *             ))
 *             .scopes("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1")
 *             .severity(4)
 *             .skipQueryValidation(true)
 *             .targetResourceTypes("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT10M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a scheduled query rule on Subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledQueryRule = new AzureNative.Insights.ScheduledQueryRule("scheduledQueryRule", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionsArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup",
 *             },
 *             CustomProperties =
 *             {
 *                 { "key11", "value11" },
 *                 { "key12", "value12" },
 *             },
 *         },
 *         CheckWorkspaceAlertsStorageConfigured = true,
 *         Criteria = new AzureNative.Insights.Inputs.ScheduledQueryRuleCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ConditionArgs
 *                 {
 *                     Dimensions = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "ComputerIp",
 *                             Operator = "Exclude",
 *                             Values = new[]
 *                             {
 *                                 "192.168.1.1",
 *                             },
 *                         },
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "OSType",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                     },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.ConditionFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 1,
 *                         NumberOfEvaluationPeriods = 1,
 *                     },
 *                     MetricMeasureColumn = "% Processor Time",
 *                     Operator = "GreaterThan",
 *                     Query = "Perf | where ObjectName == \"Processor\"",
 *                     ResourceIdColumn = "resourceId",
 *                     Threshold = 70,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *         },
 *         Description = "Performance rule",
 *         Enabled = true,
 *         EvaluationFrequency = "PT5M",
 *         Location = "eastus",
 *         MuteActionsDuration = "PT30M",
 *         ResourceGroupName = "QueryResourceGroupName",
 *         RuleName = "perf",
 *         RuleResolveConfiguration = new AzureNative.Insights.Inputs.RuleResolveConfigurationArgs
 *         {
 *             AutoResolved = true,
 *             TimeToResolve = "PT10M",
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147",
 *         },
 *         Severity = 4,
 *         SkipQueryValidation = true,
 *         TargetResourceTypes = new[]
 *         {
 *             "Microsoft.Compute/virtualMachines",
 *         },
 *         WindowSize = "PT10M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewScheduledQueryRule(ctx, "scheduledQueryRule", &insights.ScheduledQueryRuleArgs{
 * Actions: &insights.ActionsArgs{
 * ActionGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 * },
 * CustomProperties: pulumi.StringMap{
 * "key11": pulumi.String("value11"),
 * "key12": pulumi.String("value12"),
 * },
 * },
 * CheckWorkspaceAlertsStorageConfigured: pulumi.Bool(true),
 * Criteria: insights.ScheduledQueryRuleCriteriaResponse{
 * AllOf: insights.ConditionArray{
 * interface{}{
 * Dimensions: insights.DimensionArray{
 * &insights.DimensionArgs{
 * Name: pulumi.String("ComputerIp"),
 * Operator: pulumi.String("Exclude"),
 * Values: pulumi.StringArray{
 * pulumi.String("192.168.1.1"),
 * },
 * },
 * &insights.DimensionArgs{
 * Name: pulumi.String("OSType"),
 * Operator: pulumi.String("Include"),
 * Values: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * },
 * },
 * FailingPeriods: &insights.ConditionFailingPeriodsArgs{
 * MinFailingPeriodsToAlert: pulumi.Float64(1),
 * NumberOfEvaluationPeriods: pulumi.Float64(1),
 * },
 * MetricMeasureColumn: pulumi.String("% Processor Time"),
 * Operator: pulumi.String("GreaterThan"),
 * Query: pulumi.String("Perf | where ObjectName == \"Processor\""),
 * ResourceIdColumn: pulumi.String("resourceId"),
 * Threshold: pulumi.Float64(70),
 * TimeAggregation: pulumi.String("Average"),
 * },
 * },
 * },
 * Description: pulumi.String("Performance rule"),
 * Enabled: pulumi.Bool(true),
 * EvaluationFrequency: pulumi.String("PT5M"),
 * Location: pulumi.String("eastus"),
 * MuteActionsDuration: pulumi.String("PT30M"),
 * ResourceGroupName: pulumi.String("QueryResourceGroupName"),
 * RuleName: pulumi.String("perf"),
 * RuleResolveConfiguration: &insights.RuleResolveConfigurationArgs{
 * AutoResolved: pulumi.Bool(true),
 * TimeToResolve: pulumi.String("PT10M"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147"),
 * },
 * Severity: pulumi.Float64(4),
 * SkipQueryValidation: pulumi.Bool(true),
 * TargetResourceTypes: pulumi.StringArray{
 * pulumi.String("Microsoft.Compute/virtualMachines"),
 * },
 * WindowSize: pulumi.String("PT10M"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ScheduledQueryRule;
 * import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledQueryRule = new ScheduledQueryRule("scheduledQueryRule", ScheduledQueryRuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroups", "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .checkWorkspaceAlertsStorageConfigured(true)
 *             .criteria(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("dimensions",
 *                     Map.ofEntries(
 *                         Map.entry("name", "ComputerIp"),
 *                         Map.entry("operator", "Exclude"),
 *                         Map.entry("values", "192.168.1.1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "OSType"),
 *                         Map.entry("operator", "Include"),
 *                         Map.entry("values", "*")
 *                     )),
 *                 Map.entry("failingPeriods", Map.ofEntries(
 *                     Map.entry("minFailingPeriodsToAlert", 1),
 *                     Map.entry("numberOfEvaluationPeriods", 1)
 *                 )),
 *                 Map.entry("metricMeasureColumn", "% Processor Time"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("query", "Perf | where ObjectName == \"Processor\""),
 *                 Map.entry("resourceIdColumn", "resourceId"),
 *                 Map.entry("threshold", 70),
 *                 Map.entry("timeAggregation", "Average")
 *             )))
 *             .description("Performance rule")
 *             .enabled(true)
 *             .evaluationFrequency("PT5M")
 *             .location("eastus")
 *             .muteActionsDuration("PT30M")
 *             .resourceGroupName("QueryResourceGroupName")
 *             .ruleName("perf")
 *             .ruleResolveConfiguration(Map.ofEntries(
 *                 Map.entry("autoResolved", true),
 *                 Map.entry("timeToResolve", "PT10M")
 *             ))
 *             .scopes("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147")
 *             .severity(4)
 *             .skipQueryValidation(true)
 *             .targetResourceTypes("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT10M")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ScheduledQueryRule perf /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/scheduledQueryRules/{ruleName}
 * ```
 */
public class ScheduledQueryRule internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ScheduledQueryRule,
) : KotlinCustomResource(javaResource, ScheduledQueryRuleMapper) {
    /**
     * Actions to invoke when the alert fires.
     */
    public val actions: Output<ActionsResponse>?
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    actionsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
     */
    public val autoMitigate: Output<Boolean>?
        get() = javaResource.autoMitigate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert.
     */
    public val checkWorkspaceAlertsStorageConfigured: Output<Boolean>?
        get() = javaResource.checkWorkspaceAlertsStorageConfigured().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The api-version used when creating this alert rule
     */
    public val createdWithApiVersion: Output<String>
        get() = javaResource.createdWithApiVersion().applyValue({ args0 -> args0 })

    /**
     * The rule criteria that defines the conditions of the scheduled query rule.
     */
    public val criteria: Output<ScheduledQueryRuleCriteriaResponse>
        get() = javaResource.criteria().applyValue({ args0 ->
            args0.let({ args0 ->
                scheduledQueryRuleCriteriaResponseToKotlin(args0)
            })
        })

    /**
     * The description of the scheduled query rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the alert rule
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
     */
    public val evaluationFrequency: Output<String>?
        get() = javaResource.evaluationFrequency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * True if alert rule is legacy Log Analytic rule
     */
    public val isLegacyLogAnalyticsRule: Output<Boolean>
        get() = javaResource.isLegacyLogAnalyticsRule().applyValue({ args0 -> args0 })

    /**
     * The flag which indicates whether this scheduled query rule has been configured to be stored in the customer's storage. The default is false.
     */
    public val isWorkspaceAlertsStorageConfigured: Output<Boolean>
        get() = javaResource.isWorkspaceAlertsStorageConfigured().applyValue({ args0 -> args0 })

    /**
     * Indicates the type of scheduled query rule. The default is LogAlert.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
     */
    public val muteActionsDuration: Output<String>?
        get() = javaResource.muteActionsDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
     */
    public val overrideQueryTimeRange: Output<String>?
        get() = javaResource.overrideQueryTimeRange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines the configuration for resolving fired alerts. Relevant only for rules of the kind LogAlert.
     */
    public val ruleResolveConfiguration: Output<RuleResolveConfigurationResponse>?
        get() = javaResource.ruleResolveConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ruleResolveConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of resource id's that this scheduled query rule is scoped to.
     */
    public val scopes: Output<List<String>>
        get() = javaResource.scopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert.
     */
    public val severity: Output<Double>?
        get() = javaResource.severity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert.
     */
    public val skipQueryValidation: Output<Boolean>?
        get() = javaResource.skipQueryValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SystemData of ScheduledQueryRule.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
     */
    public val targetResourceTypes: Output<List<String>>?
        get() = javaResource.targetResourceTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
     */
    public val windowSize: Output<String>?
        get() = javaResource.windowSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ScheduledQueryRuleMapper : ResourceMapper<ScheduledQueryRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ScheduledQueryRule::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledQueryRule = ScheduledQueryRule(
        javaResource as
            com.pulumi.azurenative.insights.ScheduledQueryRule,
    )
}

/**
 * @see [ScheduledQueryRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledQueryRule].
 */
public suspend fun scheduledQueryRule(
    name: String,
    block: suspend ScheduledQueryRuleResourceBuilder.() -> Unit,
): ScheduledQueryRule {
    val builder = ScheduledQueryRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledQueryRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledQueryRule(name: String): ScheduledQueryRule {
    val builder = ScheduledQueryRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
