@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.WebTestArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.WebTestKind
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestGeolocationArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestGeolocationArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestPropertiesConfigurationArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestPropertiesConfigurationArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestPropertiesRequestArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestPropertiesRequestArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestPropertiesValidationRulesArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebTestPropertiesValidationRulesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Application Insights WebTest definition.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2015-05-01.
 * Other available API versions: 2020-10-05-preview.
 * ## Example Usage
 * ### webTestCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webTest = new AzureNative.Insights.WebTest("webTest", new()
 *     {
 *         Configuration = new AzureNative.Insights.Inputs.WebTestPropertiesConfigurationArgs
 *         {
 *             WebTest = "<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"120\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"120\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>",
 *         },
 *         Description = "Ping web test alert for mytestwebapp",
 *         Enabled = true,
 *         Frequency = 900,
 *         Kind = AzureNative.Insights.WebTestKind.Ping,
 *         Location = "South Central US",
 *         Locations = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "us-fl-mia-edge",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         RetryEnabled = true,
 *         SyntheticMonitorId = "my-webtest-my-component",
 *         Timeout = 120,
 *         WebTestKind = AzureNative.Insights.WebTestKind.Ping,
 *         WebTestName = "my-webtest-my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWebTest(ctx, "webTest", &insights.WebTestArgs{
 * 			Configuration: &insights.WebTestPropertiesConfigurationArgs{
 * 				WebTest: pulumi.String("<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"120\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"120\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>"),
 * 			},
 * 			Description: pulumi.String("Ping web test alert for mytestwebapp"),
 * 			Enabled:     pulumi.Bool(true),
 * 			Frequency:   pulumi.Int(900),
 * 			Kind:        insights.WebTestKindPing,
 * 			Location:    pulumi.String("South Central US"),
 * 			Locations: []insights.WebTestGeolocationArgs{
 * 				{
 * 					Location: pulumi.String("us-fl-mia-edge"),
 * 				},
 * 			},
 * 			ResourceGroupName:  pulumi.String("my-resource-group"),
 * 			RetryEnabled:       pulumi.Bool(true),
 * 			SyntheticMonitorId: pulumi.String("my-webtest-my-component"),
 * 			Timeout:            pulumi.Int(120),
 * 			WebTestKind:        insights.WebTestKindPing,
 * 			WebTestName:        pulumi.String("my-webtest-my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WebTest;
 * import com.pulumi.azurenative.insights.WebTestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webTest = new WebTest("webTest", WebTestArgs.builder()
 *             .configuration(Map.of("webTest", "<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"120\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"120\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>"))
 *             .description("Ping web test alert for mytestwebapp")
 *             .enabled(true)
 *             .frequency(900)
 *             .kind("ping")
 *             .location("South Central US")
 *             .locations(Map.of("location", "us-fl-mia-edge"))
 *             .resourceGroupName("my-resource-group")
 *             .retryEnabled(true)
 *             .syntheticMonitorId("my-webtest-my-component")
 *             .timeout(120)
 *             .webTestKind("ping")
 *             .webTestName("my-webtest-my-component")
 *             .build());
 *     }
 * }
 * ```
 * ### webTestCreateStandard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webTest = new AzureNative.Insights.WebTest("webTest", new()
 *     {
 *         Description = "Ping web test alert for mytestwebapp",
 *         Enabled = true,
 *         Frequency = 900,
 *         Location = "South Central US",
 *         Locations = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "us-fl-mia-edge",
 *             },
 *         },
 *         Request = new AzureNative.Insights.Inputs.WebTestPropertiesRequestArgs
 *         {
 *             Headers = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.HeaderFieldArgs
 *                 {
 *                     HeaderFieldName = "Content-Language",
 *                     HeaderFieldValue = "de-DE",
 *                 },
 *                 new AzureNative.Insights.Inputs.HeaderFieldArgs
 *                 {
 *                     HeaderFieldName = "Accept-Language",
 *                     HeaderFieldValue = "de-DE",
 *                 },
 *             },
 *             HttpVerb = "POST",
 *             RequestBody = "SGVsbG8gd29ybGQ=",
 *             RequestUrl = "https://bing.com",
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         RetryEnabled = true,
 *         SyntheticMonitorId = "my-webtest-my-component",
 *         Timeout = 120,
 *         ValidationRules = new AzureNative.Insights.Inputs.WebTestPropertiesValidationRulesArgs
 *         {
 *             SSLCertRemainingLifetimeCheck = 100,
 *             SSLCheck = true,
 *         },
 *         WebTestKind = AzureNative.Insights.WebTestKind.Standard,
 *         WebTestName = "my-webtest-my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWebTest(ctx, "webTest", &insights.WebTestArgs{
 * 			Description: pulumi.String("Ping web test alert for mytestwebapp"),
 * 			Enabled:     pulumi.Bool(true),
 * 			Frequency:   pulumi.Int(900),
 * 			Location:    pulumi.String("South Central US"),
 * 			Locations: []insights.WebTestGeolocationArgs{
 * 				{
 * 					Location: pulumi.String("us-fl-mia-edge"),
 * 				},
 * 			},
 * 			Request: insights.WebTestPropertiesResponseRequest{
 * 				Headers: insights.HeaderFieldArray{
 * 					&insights.HeaderFieldArgs{
 * 						HeaderFieldName:  pulumi.String("Content-Language"),
 * 						HeaderFieldValue: pulumi.String("de-DE"),
 * 					},
 * 					&insights.HeaderFieldArgs{
 * 						HeaderFieldName:  pulumi.String("Accept-Language"),
 * 						HeaderFieldValue: pulumi.String("de-DE"),
 * 					},
 * 				},
 * 				HttpVerb:    pulumi.String("POST"),
 * 				RequestBody: pulumi.String("SGVsbG8gd29ybGQ="),
 * 				RequestUrl:  pulumi.String("https://bing.com"),
 * 			},
 * 			ResourceGroupName:  pulumi.String("my-resource-group"),
 * 			RetryEnabled:       pulumi.Bool(true),
 * 			SyntheticMonitorId: pulumi.String("my-webtest-my-component"),
 * 			Timeout:            pulumi.Int(120),
 * 			ValidationRules: &insights.WebTestPropertiesValidationRulesArgs{
 * 				SSLCertRemainingLifetimeCheck: pulumi.Int(100),
 * 				SSLCheck:                      pulumi.Bool(true),
 * 			},
 * 			WebTestKind: insights.WebTestKindStandard,
 * 			WebTestName: pulumi.String("my-webtest-my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WebTest;
 * import com.pulumi.azurenative.insights.WebTestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webTest = new WebTest("webTest", WebTestArgs.builder()
 *             .description("Ping web test alert for mytestwebapp")
 *             .enabled(true)
 *             .frequency(900)
 *             .location("South Central US")
 *             .locations(Map.of("location", "us-fl-mia-edge"))
 *             .request(Map.ofEntries(
 *                 Map.entry("headers",
 *                     Map.ofEntries(
 *                         Map.entry("headerFieldName", "Content-Language"),
 *                         Map.entry("headerFieldValue", "de-DE")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("headerFieldName", "Accept-Language"),
 *                         Map.entry("headerFieldValue", "de-DE")
 *                     )),
 *                 Map.entry("httpVerb", "POST"),
 *                 Map.entry("requestBody", "SGVsbG8gd29ybGQ="),
 *                 Map.entry("requestUrl", "https://bing.com")
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .retryEnabled(true)
 *             .syntheticMonitorId("my-webtest-my-component")
 *             .timeout(120)
 *             .validationRules(Map.ofEntries(
 *                 Map.entry("sSLCertRemainingLifetimeCheck", 100),
 *                 Map.entry("sSLCheck", true)
 *             ))
 *             .webTestKind("standard")
 *             .webTestName("my-webtest-my-component")
 *             .build());
 *     }
 * }
 * ```
 * ### webTestUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webTest = new AzureNative.Insights.WebTest("webTest", new()
 *     {
 *         Configuration = new AzureNative.Insights.Inputs.WebTestPropertiesConfigurationArgs
 *         {
 *             WebTest = "<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"30\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"30\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>",
 *         },
 *         Frequency = 600,
 *         Kind = AzureNative.Insights.WebTestKind.Ping,
 *         Location = "South Central US",
 *         Locations = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "us-fl-mia-edge",
 *             },
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "apac-hk-hkn-azr",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         SyntheticMonitorId = "my-webtest-my-component",
 *         Timeout = 30,
 *         WebTestKind = AzureNative.Insights.WebTestKind.Ping,
 *         WebTestName = "my-webtest-my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWebTest(ctx, "webTest", &insights.WebTestArgs{
 * 			Configuration: &insights.WebTestPropertiesConfigurationArgs{
 * 				WebTest: pulumi.String("<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"30\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"30\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>"),
 * 			},
 * 			Frequency: pulumi.Int(600),
 * 			Kind:      insights.WebTestKindPing,
 * 			Location:  pulumi.String("South Central US"),
 * 			Locations: []insights.WebTestGeolocationArgs{
 * 				{
 * 					Location: pulumi.String("us-fl-mia-edge"),
 * 				},
 * 				{
 * 					Location: pulumi.String("apac-hk-hkn-azr"),
 * 				},
 * 			},
 * 			ResourceGroupName:  pulumi.String("my-resource-group"),
 * 			SyntheticMonitorId: pulumi.String("my-webtest-my-component"),
 * 			Timeout:            pulumi.Int(30),
 * 			WebTestKind:        insights.WebTestKindPing,
 * 			WebTestName:        pulumi.String("my-webtest-my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WebTest;
 * import com.pulumi.azurenative.insights.WebTestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webTest = new WebTest("webTest", WebTestArgs.builder()
 *             .configuration(Map.of("webTest", "<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"30\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"30\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>"))
 *             .frequency(600)
 *             .kind("ping")
 *             .location("South Central US")
 *             .locations(
 *                 Map.of("location", "us-fl-mia-edge"),
 *                 Map.of("location", "apac-hk-hkn-azr"))
 *             .resourceGroupName("my-resource-group")
 *             .syntheticMonitorId("my-webtest-my-component")
 *             .timeout(30)
 *             .webTestKind("ping")
 *             .webTestName("my-webtest-my-component")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:WebTest my-webtest-my-component /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}
 * ```
 * @property configuration An XML configuration specification for a WebTest.
 * @property description User defined description for this WebTest.
 * @property enabled Is the test actively being monitored.
 * @property frequency Interval in seconds between test runs for this WebTest. Default value is 300.
 * @property kind The kind of WebTest that this web test watches. Choices are ping, multistep and standard.
 * @property location Resource location
 * @property locations A list of where to physically run the tests from to give global coverage for accessibility of your application.
 * @property request The collection of request properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property retryEnabled Allow for retries should this WebTest fail.
 * @property syntheticMonitorId Unique ID of this WebTest. This is typically the same value as the Name field.
 * @property tags Resource tags
 * @property timeout Seconds until this WebTest will timeout and fail. Default value is 30.
 * @property validationRules The collection of validation rule properties
 * @property webTestKind The kind of web test this is, valid choices are ping, multistep and standard.
 * @property webTestName User defined name if this WebTest.
 */
public data class WebTestArgs(
    public val configuration: Output<WebTestPropertiesConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val frequency: Output<Int>? = null,
    public val kind: Output<WebTestKind>? = null,
    public val location: Output<String>? = null,
    public val locations: Output<List<WebTestGeolocationArgs>>? = null,
    public val request: Output<WebTestPropertiesRequestArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retryEnabled: Output<Boolean>? = null,
    public val syntheticMonitorId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<Int>? = null,
    public val validationRules: Output<WebTestPropertiesValidationRulesArgs>? = null,
    public val webTestKind: Output<WebTestKind>? = null,
    public val webTestName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.WebTestArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.WebTestArgs =
        com.pulumi.azurenative.insights.WebTestArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .frequency(frequency?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .locations(
                locations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .request(request?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retryEnabled(retryEnabled?.applyValue({ args0 -> args0 }))
            .syntheticMonitorId(syntheticMonitorId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .validationRules(validationRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webTestKind(webTestKind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webTestName(webTestName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebTestArgs].
 */
@PulumiTagMarker
public class WebTestArgsBuilder internal constructor() {
    private var configuration: Output<WebTestPropertiesConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var frequency: Output<Int>? = null

    private var kind: Output<WebTestKind>? = null

    private var location: Output<String>? = null

    private var locations: Output<List<WebTestGeolocationArgs>>? = null

    private var request: Output<WebTestPropertiesRequestArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var retryEnabled: Output<Boolean>? = null

    private var syntheticMonitorId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<Int>? = null

    private var validationRules: Output<WebTestPropertiesValidationRulesArgs>? = null

    private var webTestKind: Output<WebTestKind>? = null

    private var webTestName: Output<String>? = null

    /**
     * @param value An XML configuration specification for a WebTest.
     */
    @JvmName("ddpyiwbuttsdxcdy")
    public suspend fun configuration(`value`: Output<WebTestPropertiesConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value User defined description for this WebTest.
     */
    @JvmName("ftqetrbalnuftnpy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Is the test actively being monitored.
     */
    @JvmName("egydkfmaoupikkgw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Interval in seconds between test runs for this WebTest. Default value is 300.
     */
    @JvmName("arhgmpihbqvsdobe")
    public suspend fun frequency(`value`: Output<Int>) {
        this.frequency = value
    }

    /**
     * @param value The kind of WebTest that this web test watches. Choices are ping, multistep and standard.
     */
    @JvmName("tjghpssjqwjicgdw")
    public suspend fun kind(`value`: Output<WebTestKind>) {
        this.kind = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("dgkbaapvcneagfyf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("dyqalafmtgmankkx")
    public suspend fun locations(`value`: Output<List<WebTestGeolocationArgs>>) {
        this.locations = value
    }

    @JvmName("scurbdveaslxybfh")
    public suspend fun locations(vararg values: Output<WebTestGeolocationArgs>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("jxrxhodmcoxlfvmj")
    public suspend fun locations(values: List<Output<WebTestGeolocationArgs>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The collection of request properties
     */
    @JvmName("cnnjffsnntbsdnfi")
    public suspend fun request(`value`: Output<WebTestPropertiesRequestArgs>) {
        this.request = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hiqgjdxrrnefrkjl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Allow for retries should this WebTest fail.
     */
    @JvmName("xirhwumvorutoyqf")
    public suspend fun retryEnabled(`value`: Output<Boolean>) {
        this.retryEnabled = value
    }

    /**
     * @param value Unique ID of this WebTest. This is typically the same value as the Name field.
     */
    @JvmName("ifmieonhefehblpa")
    public suspend fun syntheticMonitorId(`value`: Output<String>) {
        this.syntheticMonitorId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("aaavpmqktlxmauyj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Seconds until this WebTest will timeout and fail. Default value is 30.
     */
    @JvmName("sxmfxhxufmpuwfhw")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The collection of validation rule properties
     */
    @JvmName("jyobxytacyhmspiw")
    public suspend fun validationRules(`value`: Output<WebTestPropertiesValidationRulesArgs>) {
        this.validationRules = value
    }

    /**
     * @param value The kind of web test this is, valid choices are ping, multistep and standard.
     */
    @JvmName("ncfgirpytfmnshsp")
    public suspend fun webTestKind(`value`: Output<WebTestKind>) {
        this.webTestKind = value
    }

    /**
     * @param value User defined name if this WebTest.
     */
    @JvmName("xrnbwripemsgtpyy")
    public suspend fun webTestName(`value`: Output<String>) {
        this.webTestName = value
    }

    /**
     * @param value An XML configuration specification for a WebTest.
     */
    @JvmName("oglxdedfvwxcgkyi")
    public suspend fun configuration(`value`: WebTestPropertiesConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument An XML configuration specification for a WebTest.
     */
    @JvmName("yhpbuinpbwrtdlwl")
    public suspend
    fun configuration(argument: suspend WebTestPropertiesConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebTestPropertiesConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value User defined description for this WebTest.
     */
    @JvmName("vdcbeiyyrlqmalpn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Is the test actively being monitored.
     */
    @JvmName("kglqcumrdvblgvqq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Interval in seconds between test runs for this WebTest. Default value is 300.
     */
    @JvmName("fesarrnimodbbixq")
    public suspend fun frequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The kind of WebTest that this web test watches. Choices are ping, multistep and standard.
     */
    @JvmName("patjjaurkomqdpfp")
    public suspend fun kind(`value`: WebTestKind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("refdrvpjlcqvcxga")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("pbsiudiqbhqdtovh")
    public suspend fun locations(`value`: List<WebTestGeolocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param argument A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("ihvdtguiaccrqtfx")
    public suspend fun locations(argument: List<suspend WebTestGeolocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebTestGeolocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param argument A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("ydscyhulknjibqip")
    public suspend fun locations(vararg argument: suspend WebTestGeolocationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebTestGeolocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param argument A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("cmdwjbvjvbmorvey")
    public suspend fun locations(argument: suspend WebTestGeolocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebTestGeolocationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param values A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    @JvmName("vfomgvudesplkndk")
    public suspend fun locations(vararg values: WebTestGeolocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value The collection of request properties
     */
    @JvmName("fxqwhedsyhjtgfil")
    public suspend fun request(`value`: WebTestPropertiesRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param argument The collection of request properties
     */
    @JvmName("sgmargpiagidtfgu")
    public suspend fun request(argument: suspend WebTestPropertiesRequestArgsBuilder.() -> Unit) {
        val toBeMapped = WebTestPropertiesRequestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.request = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("agqimtoajnkjopqx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Allow for retries should this WebTest fail.
     */
    @JvmName("oxditueqqlyunnlf")
    public suspend fun retryEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryEnabled = mapped
    }

    /**
     * @param value Unique ID of this WebTest. This is typically the same value as the Name field.
     */
    @JvmName("nmexoalqxdoejxlv")
    public suspend fun syntheticMonitorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syntheticMonitorId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("kkpttnwflugdhbjd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("fgdqdtrweoccomcj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Seconds until this WebTest will timeout and fail. Default value is 30.
     */
    @JvmName("nhoossifbqswmrvu")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The collection of validation rule properties
     */
    @JvmName("iaxyoxnpkussfnml")
    public suspend fun validationRules(`value`: WebTestPropertiesValidationRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationRules = mapped
    }

    /**
     * @param argument The collection of validation rule properties
     */
    @JvmName("itegkclybwtystqk")
    public suspend
    fun validationRules(argument: suspend WebTestPropertiesValidationRulesArgsBuilder.() -> Unit) {
        val toBeMapped = WebTestPropertiesValidationRulesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.validationRules = mapped
    }

    /**
     * @param value The kind of web test this is, valid choices are ping, multistep and standard.
     */
    @JvmName("pcaxiutfvpmdgbrp")
    public suspend fun webTestKind(`value`: WebTestKind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webTestKind = mapped
    }

    /**
     * @param value User defined name if this WebTest.
     */
    @JvmName("ahfciytnvrswbyjw")
    public suspend fun webTestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webTestName = mapped
    }

    internal fun build(): WebTestArgs = WebTestArgs(
        configuration = configuration,
        description = description,
        enabled = enabled,
        frequency = frequency,
        kind = kind,
        location = location,
        locations = locations,
        request = request,
        resourceGroupName = resourceGroupName,
        retryEnabled = retryEnabled,
        syntheticMonitorId = syntheticMonitorId,
        tags = tags,
        timeout = timeout,
        validationRules = validationRules,
        webTestKind = webTestKind,
        webTestName = webTestName,
    )
}
